/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.writer;

import java.util.TimeZone;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.monitor.impl.writer.BooleanWriter;
import org.fabric3.monitor.impl.writer.ByteWriter;
import org.fabric3.monitor.impl.writer.CharSequenceWriter;
import org.fabric3.monitor.impl.writer.CharWriter;
import org.fabric3.monitor.impl.writer.DoubleWriter;
import org.fabric3.monitor.impl.writer.EventWriterMonitor;
import org.fabric3.monitor.impl.writer.FloatWriter;
import org.fabric3.monitor.impl.writer.FormattingTimestampWriter;
import org.fabric3.monitor.impl.writer.IntWriter;
import org.fabric3.monitor.impl.writer.LongTimestampWriter;
import org.fabric3.monitor.impl.writer.LongWriter;
import org.fabric3.monitor.impl.writer.MonitorLevelWriter;
import org.fabric3.monitor.impl.writer.NoOpTimestampWriter;
import org.fabric3.monitor.impl.writer.ObjectWriter;
import org.fabric3.monitor.impl.writer.TimestampWriter;
import org.fabric3.monitor.spi.buffer.ResizableByteBuffer;
import org.fabric3.monitor.spi.event.MonitorEventEntry;
import org.fabric3.monitor.spi.event.ParameterEntry;
import org.fabric3.monitor.spi.writer.EventWriter;
import org.oasisopen.sca.ServiceRuntimeException;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;

public class EventWriterImpl
implements EventWriter {
    private static final byte[] NEWLINE = "\n".getBytes();
    private EventWriterMonitor monitor;
    private String timestampType = "formatted";
    private String pattern = "%d.%m.%Y %H:%i:%s.%F";
    private TimeZone timeZone = TimeZone.getDefault();
    private TimestampWriter timestampWriter;

    public EventWriterImpl(@Monitor EventWriterMonitor monitor) {
        this.monitor = monitor;
    }

    @Property(required=false)
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Property(required=false)
    public void setTimeZone(String id) {
        this.timeZone = TimeZone.getTimeZone(id);
    }

    @Property(required=false)
    public void setTimestampFormat(String type) {
        this.timestampType = type;
    }

    @Init
    public void init() {
        this.initializeTimestampWriter();
    }

    @Override
    public void write(MonitorLevel level, long timestamp, String template, ResizableByteBuffer buffer, Object[] args) {
        int bytesWritten = 0;
        bytesWritten += this.writePrefix(level, timestamp, buffer);
        bytesWritten += this.writeTemplate(template, args, buffer);
        buffer.put(NEWLINE);
        buffer.limit(++bytesWritten);
    }

    @Override
    public int writePrefix(MonitorLevel level, long timestamp, ResizableByteBuffer buffer) {
        int bytesWritten = 0;
        buffer.put(91);
        ++bytesWritten;
        int written = MonitorLevelWriter.write(level, buffer);
        bytesWritten += written;
        buffer.put(32);
        ++bytesWritten;
        written = this.timestampWriter.write(timestamp, buffer);
        if (written == 0) {
            buffer.position(buffer.position() - 1);
        } else {
            bytesWritten += written;
        }
        buffer.put(93);
        ++bytesWritten;
        buffer.put(32);
        return ++bytesWritten;
    }

    @Override
    public int writeTemplate(MonitorEventEntry entry) {
        ParameterEntry last;
        String template = entry.getTemplate();
        if (template == null) {
            return 0;
        }
        ResizableByteBuffer buffer = entry.getBuffer();
        int bytesWritten = 0;
        int counter = 0;
        ParameterEntry[] entries = entry.getEntries();
        for (int i = 0; i < template.length(); ++i) {
            char current = template.charAt(i);
            if (entry.isParse() && '{' == current) {
                if (counter > entry.getLimit()) {
                    throw new ServiceRuntimeException("Monitor message contains more parameters than are supplied by the method interface: " + template);
                }
                ParameterEntry parameterEntry = entries[counter];
                bytesWritten += this.writeParameter(parameterEntry, buffer);
                int skip = 0;
                while (template.charAt(i + skip) != '}') {
                    ++skip;
                }
                i += skip;
                ++counter;
                continue;
            }
            ++bytesWritten;
            buffer.put((byte)current);
        }
        if (counter < entry.getLimit() && ParameterEntry.Slot.OBJECT == (last = entries[entry.getLimit() - 1]).getSlot() && last.getObjectValue(Object.class) instanceof Throwable) {
            bytesWritten += ObjectWriter.write(last.getObjectValue(Object.class), buffer);
        }
        return bytesWritten;
    }

    private void initializeTimestampWriter() {
        if (this.timestampType.equals("formatted")) {
            this.timestampWriter = new FormattingTimestampWriter(this.pattern, this.timeZone);
        } else if (this.timestampType.equals("unformatted")) {
            this.timestampWriter = new LongTimestampWriter();
        } else if (this.timestampType.equals("none")) {
            this.timestampWriter = new NoOpTimestampWriter();
        } else {
            this.timestampWriter = new FormattingTimestampWriter(this.pattern, this.timeZone);
            this.monitor.invalidTimestampType(this.timestampType);
        }
    }

    private int writeTemplate(String template, Object[] args, ResizableByteBuffer buffer) {
        if (template == null) {
            return 0;
        }
        int bytesWritten = 0;
        int counter = 0;
        for (int i = 0; i < template.length(); ++i) {
            char current = template.charAt(i);
            if ('{' == current && args.length > 0) {
                if (args == null || counter >= args.length) {
                    throw new ServiceRuntimeException("Monitor message contains more parameters than are supplied by the method interface: " + template);
                }
                bytesWritten += this.writeParameter(args[counter], buffer);
                int skip = 0;
                while (template.charAt(i + skip) != '}') {
                    ++skip;
                }
                i += skip;
                ++counter;
                continue;
            }
            ++bytesWritten;
            buffer.put((byte)current);
        }
        if (args != null && counter < args.length) {
            bytesWritten += this.writeParameter(args[counter], buffer);
        }
        return bytesWritten;
    }

    private int writeParameter(ParameterEntry parameterEntry, ResizableByteBuffer buffer) {
        int count = 0;
        switch (parameterEntry.getSlot()) {
            case SHORT: {
                count += IntWriter.write(parameterEntry.getShortValue(), buffer);
                break;
            }
            case INT: {
                count += IntWriter.write(parameterEntry.getIntValue(), buffer);
                break;
            }
            case LONG: {
                count += LongWriter.write(parameterEntry.getLongValue(), buffer);
                break;
            }
            case DOUBLE: {
                count += DoubleWriter.write(parameterEntry.getDoubleValue(), buffer);
                break;
            }
            case FLOAT: {
                count += FloatWriter.write(parameterEntry.getFloatValue(), buffer);
                break;
            }
            case CHAR: {
                count += CharWriter.write(parameterEntry.getCharValue(), buffer);
                break;
            }
            case BOOLEAN: {
                count += BooleanWriter.write(parameterEntry.getBooleanValue(), buffer);
                break;
            }
            case BYTE: {
                count += ByteWriter.write(parameterEntry.getByteValue(), buffer);
                break;
            }
            case OBJECT: {
                count += ObjectWriter.write(parameterEntry.getObjectValue(Object.class), buffer);
                break;
            }
        }
        return count;
    }

    private int writeParameter(Object arg, ResizableByteBuffer buffer) {
        if (arg instanceof CharSequence) {
            return CharSequenceWriter.write((CharSequence)arg, buffer);
        }
        if (arg instanceof Long) {
            return LongWriter.write((Long)arg, buffer);
        }
        if (arg instanceof Integer) {
            return IntWriter.write((Integer)arg, buffer);
        }
        if (arg instanceof Double) {
            return DoubleWriter.write((Double)arg, buffer);
        }
        if (arg instanceof Boolean) {
            return BooleanWriter.write((Boolean)arg, buffer);
        }
        return ObjectWriter.write(arg, buffer);
    }
}

