/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.writer;

import org.fabric3.monitor.impl.writer.AbstractNumericWriter;
import org.fabric3.monitor.spi.buffer.ResizableByteBuffer;

public class FloatWriter
extends AbstractNumericWriter {
    public static int write(float value, ResizableByteBuffer buffer) {
        int written = 0;
        if (Float.isNaN(value)) {
            buffer.put(NAN);
            written += 3;
        } else if (Float.isInfinite(value)) {
            if (value > 0.0f) {
                buffer.put(INFINITY);
                written += INFINITY.length;
            } else {
                buffer.put(NEGATIVE_INFINITY);
                written += NEGATIVE_INFINITY.length;
            }
        } else {
            int bits = Float.floatToRawIntBits(value);
            boolean negative = bits >>> 31 != 0;
            int binaryExponent = (bits >>> 23 & 0xFF) - 150;
            int binaryMantissa = bits & 0x7FFFFF;
            if (binaryExponent == -150) {
                binaryExponent = -149;
            } else {
                binaryMantissa += 0x800000;
            }
            double significantDigits = (double)(binaryExponent - 1) / 3.321928094887362;
            int decimalExponent = (int)Math.floor(significantDigits);
            int margin = POW_10[(int)Math.scalb(significantDigits - (double)decimalExponent, 8)];
            long decimalMantissa = FloatWriter.getDecimalMantissa(binaryMantissa, binaryExponent, decimalExponent);
            int lastDigit = (int)(decimalMantissa % 10L);
            if (lastDigit <= margin) {
                decimalMantissa /= 10L;
                ++decimalExponent;
            } else if (lastDigit >= 10 - margin) {
                decimalMantissa = decimalMantissa / 10L + 1L;
                ++decimalExponent;
            }
            written += FloatWriter.formatSimple(negative, decimalMantissa, decimalMantissa == 0L ? 0 : decimalExponent, buffer);
        }
        return written;
    }
}

