/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.writer;

import java.util.ArrayList;
import java.util.TimeZone;
import org.fabric3.monitor.impl.writer.CharSequenceWriter;
import org.fabric3.monitor.impl.writer.IntWriter;
import org.fabric3.monitor.impl.writer.LongWriter;
import org.fabric3.monitor.impl.writer.TimestampWriter;
import org.fabric3.monitor.spi.buffer.ResizableByteBuffer;

public class FormattingTimestampWriter
implements TimestampWriter {
    private static final ThreadLocal<ExtractedYearMonth> EXTRACTED_YEAR_MONTH = new ThreadLocal<ExtractedYearMonth>(){

        @Override
        protected ExtractedYearMonth initialValue() {
            return new ExtractedYearMonth();
        }
    };
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long[] MONTH = new long[]{2678400000L, 2419200000L, 2678400000L, 2592000000L, 2678400000L, 2592000000L, 2678400000L, 2678400000L, 2592000000L, 2678400000L, 2592000000L, 2678400000L};
    private static final long[] LEAP_MONTH = new long[]{2678400000L, 2505600000L, 2678400000L, 2592000000L, 2678400000L, 2592000000L, 2678400000L, 2678400000L, 2592000000L, 2678400000L, 2592000000L, 2678400000L};
    private static final long YEAR = 31536000000L;
    private static final long LEAP_YEAR = 31622400000L;
    private static final long YEAR_4 = 126230400000L;
    private static final long LEAP_YEAR_4 = 126144000000L;
    private static final long YEAR_28 = 883612800000L;
    private static final long YEAR_100 = 3155673600000L;
    private static final long LEAP_YEAR_100 = 3155760000000L;
    private static final long LEAP_YEAR_200 = 6311433600000L;
    private static final long LEAP_YEAR_300 = 9467107200000L;
    private static final long YEAR_400 = 12622780800000L;
    private final LongFormatter[] chunks;
    private TimeZone tz;

    public FormattingTimestampWriter(String pattern, TimeZone timeZone) {
        this.tz = timeZone;
        ArrayList<LongFormatter> chunks = new ArrayList<LongFormatter>();
        int length = pattern.length();
        int state = 0;
        StringBuilder literal = new StringBuilder();
        block31: for (int i = 0; i < length; ++i) {
            char ch = pattern.charAt(i);
            switch (state) {
                case 0: {
                    switch (ch) {
                        case '%': {
                            state = 1;
                            continue block31;
                        }
                    }
                    literal.append(ch);
                    continue block31;
                }
                case 1: {
                    switch (ch) {
                        case 'a': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(AbbreviatedWeekdayName.INSTANCE);
                            break;
                        }
                        case 'b': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(AbbreviatedMonthName.INSTANCE);
                            break;
                        }
                        case 'c': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(MonthNumeric.INSTANCE);
                            break;
                        }
                        case 'd': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(DayOfMonthNumeric2.INSTANCE);
                            break;
                        }
                        case 'e': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(DayOfMonthNumeric.INSTANCE);
                            break;
                        }
                        case 'f': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(Milliseconds.INSTANCE);
                            break;
                        }
                        case 'F': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(Milliseconds3.INSTANCE);
                            break;
                        }
                        case 'H': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(Hour24_2.INSTANCE);
                            break;
                        }
                        case 'h': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(Hour12_2.INSTANCE);
                            break;
                        }
                        case 'i': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(Minutes2.INSTANCE);
                            break;
                        }
                        case 'j': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(DayOfYear3.INSTANCE);
                            break;
                        }
                        case 'k': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(Hour24.INSTANCE);
                            break;
                        }
                        case 'l': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(Hour12.INSTANCE);
                            break;
                        }
                        case 'M': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(MonthName.INSTANCE);
                            break;
                        }
                        case 'm': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(MonthNumeric2.INSTANCE);
                            break;
                        }
                        case 'p': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(AMPM.INSTANCE);
                            break;
                        }
                        case 'S': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(Seconds.INSTANCE);
                            break;
                        }
                        case 's': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(Seconds2.INSTANCE);
                            break;
                        }
                        case 'W': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(WeekdayName.INSTANCE);
                            break;
                        }
                        case 'w': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(DayOfWeek.INSTANCE);
                            break;
                        }
                        case 'Y': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(Year4.INSTANCE);
                            break;
                        }
                        case 'y': {
                            if (literal.length() > 0) {
                                chunks.add(new Literal(literal.toString()));
                                literal.setLength(0);
                            }
                            chunks.add(Year2.INSTANCE);
                            break;
                        }
                        default: {
                            literal.append(ch);
                        }
                    }
                    state = 0;
                    continue block31;
                }
                default: {
                    throw new Error("Unknown state: " + state);
                }
            }
        }
        if (state != 0) {
            throw new IllegalArgumentException("Unexpected end of pattern: " + pattern);
        }
        if (literal.length() > 0) {
            chunks.add(new Literal(literal.toString()));
        }
        this.chunks = chunks.toArray(new LongFormatter[chunks.size()]);
    }

    @Override
    public int write(long value, ResizableByteBuffer buffer) {
        int written = 0;
        if (this.tz != null) {
            value += (long)this.tz.getOffset(value);
        }
        if (value < 0L) {
            written += LongWriter.write(value, buffer);
        } else {
            int count = this.chunks.length;
            for (int i = 0; i < count; ++i) {
                written += this.chunks[i].format(value, buffer);
            }
        }
        return written;
    }

    private static int getMillisecond(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp (" + timestamp + ") < 0");
        }
        return (int)(timestamp % 1000L);
    }

    private static int getSecond(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp (" + timestamp + ") < 0");
        }
        return (int)(timestamp % 60000L / 1000L);
    }

    private static int getMinute(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp (" + timestamp + ") < 0");
        }
        return (int)(timestamp % 3600000L / 60000L);
    }

    private static int getHour(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp (" + timestamp + ") < 0");
        }
        return (int)(timestamp % 86400000L / 3600000L);
    }

    private static int getDayOfWeek(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp (" + timestamp + ") < 0");
        }
        return (int)((timestamp / 86400000L + 4L) % 7L);
    }

    private static int getDayOfMonth(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp (" + timestamp + ") < 0");
        }
        long m = FormattingTimestampWriter.extractMonth(timestamp);
        return (int)m;
    }

    private static int getDayOfYear(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp (" + timestamp + ") < 0");
        }
        long e = FormattingTimestampWriter.extractYear(timestamp);
        return (int)e;
    }

    private static int getMonth(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp (" + timestamp + ") < 0");
        }
        long m = FormattingTimestampWriter.extractMonth(timestamp);
        return (int)(m >>> 32);
    }

    private static int getYear(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp (" + timestamp + ") < 0");
        }
        return (int)(FormattingTimestampWriter.extractYear(timestamp) >>> 32);
    }

    private static long extractMonth(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp (" + timestamp + ") < 0");
        }
        ExtractedYearMonth eym = EXTRACTED_YEAR_MONTH.get();
        if (eym.extractedMonthTimestamp == timestamp) {
            return eym.extractedMonth;
        }
        long e = FormattingTimestampWriter.extractYear(timestamp);
        int year = (int)(e >>> 32);
        long offset = (long)((int)e) * 86400000L;
        boolean leap = FormattingTimestampWriter.isLeapYear(year);
        long[] month = leap ? LEAP_MONTH : MONTH;
        for (int i = 0; i < 12; ++i) {
            long m = month[i];
            if (offset >= m) {
                offset -= m;
                continue;
            }
            long result = ((long)i << 32) + offset / 86400000L;
            eym.extractedMonthTimestamp = timestamp;
            eym.extractedMonth = result;
            return result;
        }
        throw new Error("Impossible");
    }

    private static long extractYear(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Timestamp (" + timestamp + ") < 0");
        }
        ExtractedYearMonth eym = EXTRACTED_YEAR_MONTH.get();
        if (eym.extractedYearTimestamp == timestamp) {
            return eym.extractedYear;
        }
        int year = 1970 + (int)(timestamp / 12622780800000L) * 400;
        if ((timestamp %= 12622780800000L) < 3155760000000L) {
            year += (int)(timestamp / 126230400000L) * 4;
            timestamp %= 126230400000L;
        } else {
            if (timestamp < 6311433600000L) {
                timestamp -= 3155760000000L;
                year += 100;
            } else if (timestamp < 9467107200000L) {
                timestamp -= 6311433600000L;
                year += 200;
            } else {
                timestamp -= 9467107200000L;
                year += 300;
            }
            if (timestamp < 883612800000L) {
                year += (int)(timestamp / 126230400000L) * 4;
                timestamp %= 126230400000L;
            } else {
                year += 28;
                if ((timestamp -= 883612800000L) >= 126144000000L) {
                    year += 4;
                    year += (int)((timestamp -= 126144000000L) / 126230400000L) * 4;
                    timestamp %= 126230400000L;
                }
            }
        }
        while (true) {
            long yearLength;
            long l = yearLength = FormattingTimestampWriter.isLeapYear(year) ? 31622400000L : 31536000000L;
            if (timestamp < yearLength) break;
            timestamp -= yearLength;
            ++year;
        }
        long result = ((long)year << 32) + timestamp / 86400000L;
        eym.extractedYearTimestamp = timestamp;
        eym.extractedYear = result;
        return result;
    }

    private static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    private static int writeIntegerWidth(int value, int width, ResizableByteBuffer buffer) {
        if (value < 0) {
            throw new IllegalArgumentException("Value (" + value + ") < 0");
        }
        if (width < 0) {
            throw new IllegalArgumentException("Width (" + width + ") < 0");
        }
        int written = 0;
        int v = value;
        int n = 0;
        while (v != 0) {
            v /= 10;
            ++n;
        }
        if (n == 0) {
            n = 1;
        }
        if (n < width) {
            int count = width - n;
            while (count >= 4) {
                buffer.put(48);
                buffer.put(48);
                buffer.put(48);
                buffer.put(48);
                count -= 4;
                written += 4;
            }
            switch (count) {
                case 3: {
                    buffer.put(48);
                    buffer.put(48);
                    buffer.put(48);
                    written += 3;
                    break;
                }
                case 2: {
                    buffer.put(48);
                    buffer.put(48);
                    written += 2;
                    break;
                }
                case 1: {
                    buffer.put(48);
                    ++written;
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new Error("Impossible");
                }
            }
        }
        return written += IntWriter.write(value, buffer);
    }

    private static class ExtractedYearMonth {
        public long extractedYearTimestamp = Long.MIN_VALUE;
        public long extractedYear = Long.MIN_VALUE;
        public long extractedMonthTimestamp = Long.MIN_VALUE;
        public long extractedMonth = Long.MIN_VALUE;

        private ExtractedYearMonth() {
        }
    }

    private static interface LongFormatter {
        public int format(long var1, ResizableByteBuffer var3);
    }

    private static class Year4
    implements LongFormatter {
        private static final Year4 INSTANCE = new Year4();

        private Year4() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            return FormattingTimestampWriter.writeIntegerWidth(FormattingTimestampWriter.getYear(value), 4, buffer);
        }
    }

    private static class Year2
    implements LongFormatter {
        private static final Year2 INSTANCE = new Year2();

        private Year2() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            return FormattingTimestampWriter.writeIntegerWidth(FormattingTimestampWriter.getYear(value) % 100, 2, buffer);
        }
    }

    private static class WeekdayName
    implements LongFormatter {
        private static final WeekdayName INSTANCE = new WeekdayName();
        private static final String[] WEEKDAY_NAMES = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};

        private WeekdayName() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            String weekdayName = WEEKDAY_NAMES[FormattingTimestampWriter.getDayOfWeek(value)];
            return CharSequenceWriter.write(weekdayName, buffer);
        }
    }

    private static class Seconds2
    implements LongFormatter {
        private static final Seconds2 INSTANCE = new Seconds2();

        private Seconds2() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            return FormattingTimestampWriter.writeIntegerWidth(FormattingTimestampWriter.getSecond(value), 2, buffer);
        }
    }

    private static class Seconds
    implements LongFormatter {
        private static final Seconds INSTANCE = new Seconds();

        private Seconds() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            return IntWriter.write(FormattingTimestampWriter.getSecond(value), buffer);
        }
    }

    private static class MonthNumeric2
    implements LongFormatter {
        private static final MonthNumeric2 INSTANCE = new MonthNumeric2();

        private MonthNumeric2() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            return FormattingTimestampWriter.writeIntegerWidth(FormattingTimestampWriter.getMonth(value) + 1, 2, buffer);
        }
    }

    private static class MonthNumeric
    implements LongFormatter {
        private static final MonthNumeric INSTANCE = new MonthNumeric();

        private MonthNumeric() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            return IntWriter.write(FormattingTimestampWriter.getMonth(value) + 1, buffer);
        }
    }

    private static class MonthName
    implements LongFormatter {
        private static final MonthName INSTANCE = new MonthName();
        private static final String[] MONTH_NAMES = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

        private MonthName() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            String monthName = MONTH_NAMES[FormattingTimestampWriter.getMonth(value)];
            return CharSequenceWriter.write(monthName, buffer);
        }
    }

    private static class Minutes2
    implements LongFormatter {
        private static final Minutes2 INSTANCE = new Minutes2();

        private Minutes2() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            int minutes = FormattingTimestampWriter.getMinute(value);
            return FormattingTimestampWriter.writeIntegerWidth(minutes, 2, buffer);
        }
    }

    private static class Milliseconds3
    implements LongFormatter {
        private static final Milliseconds3 INSTANCE = new Milliseconds3();

        private Milliseconds3() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            int milliseconds = FormattingTimestampWriter.getMillisecond(value);
            return FormattingTimestampWriter.writeIntegerWidth(milliseconds, 3, buffer);
        }
    }

    private static class Milliseconds
    implements LongFormatter {
        private static final Milliseconds INSTANCE = new Milliseconds();

        private Milliseconds() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            int milliseconds = FormattingTimestampWriter.getMillisecond(value);
            return IntWriter.write(milliseconds, buffer);
        }
    }

    private static class Hour24_2
    implements LongFormatter {
        private static final Hour24_2 INSTANCE = new Hour24_2();

        private Hour24_2() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            int hour = FormattingTimestampWriter.getHour(value);
            return FormattingTimestampWriter.writeIntegerWidth(hour, 2, buffer);
        }
    }

    private static class Hour24
    implements LongFormatter {
        private static final Hour24 INSTANCE = new Hour24();

        private Hour24() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            int hour = FormattingTimestampWriter.getHour(value);
            return IntWriter.write(hour, buffer);
        }
    }

    private static class Hour12_2
    implements LongFormatter {
        private static final Hour12_2 INSTANCE = new Hour12_2();

        private Hour12_2() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            int hour = FormattingTimestampWriter.getHour(value) % 12;
            if (hour == 0) {
                hour = 12;
            }
            return FormattingTimestampWriter.writeIntegerWidth(hour, 2, buffer);
        }
    }

    private static class Hour12
    implements LongFormatter {
        private static final Hour12 INSTANCE = new Hour12();

        private Hour12() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            int hour = FormattingTimestampWriter.getHour(value) % 12;
            if (hour == 0) {
                hour = 12;
            }
            return IntWriter.write(hour, buffer);
        }
    }

    private static class DayOfYear3
    implements LongFormatter {
        private static final DayOfYear3 INSTANCE = new DayOfYear3();

        private DayOfYear3() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            int dayOfYear = FormattingTimestampWriter.getDayOfYear(value);
            return FormattingTimestampWriter.writeIntegerWidth(dayOfYear + 1, 3, buffer);
        }
    }

    private static class DayOfWeek
    implements LongFormatter {
        private static final DayOfWeek INSTANCE = new DayOfWeek();

        private DayOfWeek() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            int dayOfWeek = FormattingTimestampWriter.getDayOfWeek(value);
            return IntWriter.write(dayOfWeek + 1, buffer);
        }
    }

    private static class DayOfMonthNumeric2
    implements LongFormatter {
        private static final DayOfMonthNumeric2 INSTANCE = new DayOfMonthNumeric2();

        private DayOfMonthNumeric2() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            if (buffer == null) {
                throw new IllegalArgumentException("buffer is null");
            }
            int dayOfMonth = FormattingTimestampWriter.getDayOfMonth(value);
            return FormattingTimestampWriter.writeIntegerWidth(dayOfMonth + 1, 2, buffer);
        }
    }

    private static class DayOfMonthNumeric
    implements LongFormatter {
        private static final DayOfMonthNumeric INSTANCE = new DayOfMonthNumeric();

        private DayOfMonthNumeric() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            int dayOfMonth = FormattingTimestampWriter.getDayOfMonth(value);
            return IntWriter.write(dayOfMonth + 1, buffer);
        }
    }

    private static class AMPM
    implements LongFormatter {
        private static final AMPM INSTANCE = new AMPM();

        private AMPM() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            int hour = FormattingTimestampWriter.getHour(value);
            String ampm = hour < 12 ? "AM" : "PM";
            return CharSequenceWriter.write(ampm, buffer);
        }
    }

    private static class AbbreviatedWeekdayName
    implements LongFormatter {
        private static final AbbreviatedWeekdayName INSTANCE = new AbbreviatedWeekdayName();
        private static final String[] WEEKDAY_NAMES = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};

        private AbbreviatedWeekdayName() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            String weekdayName = WEEKDAY_NAMES[FormattingTimestampWriter.getDayOfWeek(value)];
            return CharSequenceWriter.write(weekdayName, buffer);
        }
    }

    private static class AbbreviatedMonthName
    implements LongFormatter {
        private static final AbbreviatedMonthName INSTANCE = new AbbreviatedMonthName();
        private static final String[] MONTH_NAMES = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

        private AbbreviatedMonthName() {
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            String monthName = MONTH_NAMES[FormattingTimestampWriter.getMonth(value)];
            return CharSequenceWriter.write(monthName, buffer);
        }
    }

    private class Literal
    implements LongFormatter {
        private final String literal;

        public Literal(String literal) {
            this.literal = literal;
        }

        @Override
        public int format(long value, ResizableByteBuffer buffer) {
            return CharSequenceWriter.write(this.literal, buffer);
        }
    }
}

