/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.writer;

import org.fabric3.monitor.spi.buffer.ResizableByteBuffer;

public final class IntWriter {
    private static final byte[] INT_MIN = "-2147483648".getBytes();
    private static final int[] SIZE_TABLE = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final char[] DIGIT_TENS = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] DIGIT_ONES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    private IntWriter() {
    }

    public static int write(int value, ResizableByteBuffer buffer) {
        if (value == Integer.MIN_VALUE) {
            buffer.put(INT_MIN, 0, INT_MIN.length);
            return INT_MIN.length;
        }
        return IntWriter.writeIntChars(value, buffer);
    }

    private static int stringSize(int x) {
        int i = 0;
        while (x > SIZE_TABLE[i]) {
            ++i;
        }
        return i + 1;
    }

    private static int writeIntChars(int value, ResizableByteBuffer buffer) {
        int r;
        int q;
        int index;
        int start = buffer.position();
        int size = value < 0 ? IntWriter.stringSize(-value) + 1 : IntWriter.stringSize(value);
        int charPos = index = size + start;
        int sign = 0;
        if (value < 0) {
            sign = 45;
            value = -value;
        }
        while (value >= 65536) {
            q = value / 100;
            r = value - ((q << 6) + (q << 5) + (q << 2));
            value = q;
            buffer.put(--charPos, (byte)DIGIT_ONES[r]);
            buffer.put(--charPos, (byte)DIGIT_TENS[r]);
        }
        do {
            q = value * 52429 >>> 19;
            r = value - ((q << 3) + (q << 1));
            buffer.put(--charPos, (byte)DIGITS[r]);
        } while ((value = q) != 0);
        if (sign != 0) {
            buffer.put(--charPos, (byte)sign);
        }
        buffer.position(index);
        return size;
    }
}

