/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.writer;

import org.fabric3.monitor.impl.writer.CharSequenceWriter;
import org.fabric3.monitor.impl.writer.TimestampWriter;
import org.fabric3.monitor.spi.buffer.ResizableByteBuffer;

public class LongTimestampWriter
implements TimestampWriter {
    private static final String MIN_VALUE = "-9223372036854775808";
    static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    @Override
    public int write(long value, ResizableByteBuffer buffer) {
        if (value == Long.MIN_VALUE) {
            CharSequenceWriter.write(MIN_VALUE, buffer);
            return MIN_VALUE.length();
        }
        int start = buffer.position();
        int size = value < 0L ? LongTimestampWriter.stringSize(-value) + 1 : LongTimestampWriter.stringSize(value);
        int index = size + start;
        this.getChars(value, index, buffer);
        buffer.position(index);
        return size;
    }

    void getChars(long i, int index, ResizableByteBuffer buffer) {
        int q2;
        int r;
        int charPos = index;
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buffer.put(--charPos, (byte)DigitOnes[r]);
            buffer.put(--charPos, (byte)DigitTens[r]);
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buffer.put(--charPos, (byte)DigitOnes[r]);
            buffer.put(--charPos, (byte)DigitTens[r]);
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buffer.put(--charPos, (byte)digits[r]);
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buffer.put(--charPos, (byte)sign);
        }
    }

    static int stringSize(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }
}

