/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.writer;

import org.fabric3.monitor.spi.buffer.ResizableByteBuffer;

public final class LongWriter {
    private static final byte[] LONG_MIN = "-9223372036854775808".getBytes();
    static final char[] DIGIT_TENS = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    static final char[] DIGIT_ONES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    private LongWriter() {
    }

    public static int write(long value, ResizableByteBuffer buffer) {
        if (value == Long.MIN_VALUE) {
            buffer.put(LONG_MIN, 0, LONG_MIN.length);
            return LONG_MIN.length;
        }
        if (value == 0L) {
            buffer.put(48);
            return 1;
        }
        return LongWriter.writeLongChars(value, buffer);
    }

    private static int writeLongChars(long value, ResizableByteBuffer buffer) {
        int q2;
        int r;
        int index;
        int start = buffer.position();
        int size = value < 0L ? LongWriter.stringSize(-value) + 1 : LongWriter.stringSize(value);
        int charPos = index = size + start;
        int sign = 0;
        if (value < 0L) {
            sign = 45;
            value = -value;
        }
        while (value > Integer.MAX_VALUE) {
            long q = value / 100L;
            r = (int)(value - ((q << 6) + (q << 5) + (q << 2)));
            value = q;
            buffer.put(--charPos, (byte)DIGIT_ONES[r]);
            buffer.put(--charPos, (byte)DIGIT_TENS[r]);
        }
        int i2 = (int)value;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buffer.put(--charPos, (byte)DIGIT_ONES[r]);
            buffer.put(--charPos, (byte)DIGIT_TENS[r]);
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buffer.put(--charPos, (byte)DIGITS[r]);
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buffer.put(--charPos, (byte)sign);
        }
        buffer.position(index);
        return size;
    }

    private static int stringSize(long value) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (value < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }
}

