/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.impl.writer;

import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.monitor.spi.buffer.ResizableByteBuffer;

public final class MonitorLevelWriter {
    private static final byte[] SEVERE = MonitorLevel.SEVERE.toString().getBytes();
    private static final byte[] DEBUG = MonitorLevel.DEBUG.toString().getBytes();
    private static final byte[] INFO = MonitorLevel.INFO.toString().getBytes();
    private static final byte[] TRACE = MonitorLevel.TRACE.toString().getBytes();
    private static final byte[] WARNING = MonitorLevel.WARNING.toString().getBytes();

    private MonitorLevelWriter() {
    }

    public static int write(MonitorLevel level, ResizableByteBuffer buffer) {
        switch (level) {
            case SEVERE: {
                buffer.put(SEVERE);
                return 6;
            }
            case WARNING: {
                buffer.put(WARNING);
                return 7;
            }
            case INFO: {
                buffer.put(INFO);
                return 4;
            }
            case DEBUG: {
                buffer.put(DEBUG);
                return 5;
            }
            case TRACE: {
                buffer.put(TRACE);
                return 5;
            }
        }
        throw new AssertionError();
    }
}

