/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.spi.buffer;

import java.nio.ByteBuffer;
import org.fabric3.monitor.spi.buffer.ResizableByteBufferMonitor;

public class ResizableByteBuffer {
    private static final int SIZE = 1024;
    private ByteBuffer buffer;
    private ResizableByteBufferMonitor monitor;

    public ResizableByteBuffer(ByteBuffer buffer, ResizableByteBufferMonitor monitor) {
        this.buffer = buffer;
        this.monitor = monitor;
    }

    public ResizableByteBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
        this.monitor = new ResizableByteBufferMonitor(){

            @Override
            public void bufferResize() {
            }
        };
    }

    public void put(int b) {
        this.resize(1);
        this.buffer.put((byte)b);
    }

    public void put(byte[] bytes) {
        this.resize(bytes.length);
        this.buffer.put(bytes);
    }

    public void put(byte[] bytes, int offset, int length) {
        this.resize(length);
        this.buffer.put(bytes, offset, length);
    }

    public void put(ByteBuffer from) {
        this.resize(from.capacity() - from.remaining());
        this.buffer.put(from);
    }

    public void put(int index, byte b) {
        this.resize(1);
        this.buffer.put(index, b);
    }

    public void putCharacter(char c) {
        this.resize(2);
        this.buffer.putChar(c);
    }

    public void putShort(short s) {
        this.resize(2);
        this.buffer.putShort(s);
    }

    public void putInteger(int i) {
        this.resize(4);
        this.buffer.putInt(i);
    }

    public void putFloat(float f) {
        this.resize(4);
        this.buffer.putFloat(f);
    }

    public void putDouble(double d) {
        this.resize(8);
        this.buffer.putDouble(d);
    }

    public void putLong(long l) {
        this.resize(8);
        this.buffer.putLong(l);
    }

    public void limit(int limit) {
        this.buffer.limit(limit);
    }

    public int limit() {
        return this.buffer.limit();
    }

    public void position(int position) {
        this.buffer.position(position);
    }

    public int position() {
        return this.buffer.position();
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    public void clear() {
        this.buffer.clear();
    }

    public void flip() {
        this.buffer.flip();
    }

    public void get(byte[] bytes) {
        this.buffer.get(bytes);
    }

    public byte[] array() {
        return this.buffer.array();
    }

    private void resize(int amount) {
        if (this.buffer.remaining() >= amount) {
            return;
        }
        this.monitor.bufferResize();
        ByteBuffer newBuffer = ByteBuffer.allocate(this.buffer.capacity() + amount + 1024);
        int currentPosition = this.buffer.position();
        this.buffer.position(0);
        newBuffer.put(this.buffer);
        newBuffer.position(currentPosition);
        this.buffer = newBuffer;
    }
}

