/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.node;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.fabric3.api.host.util.IOHelper;
import org.fabric3.api.node.FabricException;

public class ArchiveUtils {
    public static File getJarDirectory(Class<?> clazz) throws IllegalStateException {
        String name = ArchiveUtils.getClassFileName(clazz);
        URL url = clazz.getResource(name);
        if (url == null) {
            throw new IllegalStateException("Unable to get location of bytecode resource " + name);
        }
        String jarLocation = url.toString();
        if (!jarLocation.startsWith("jar:")) {
            throw new IllegalStateException("Must be run from a jar: " + url);
        }
        if (!(jarLocation = jarLocation.substring(4, jarLocation.lastIndexOf("!/"))).startsWith("file:")) {
            throw new IllegalStateException("Must be run from a local filesystem: " + jarLocation);
        }
        File jarFile = new File(URI.create(jarLocation));
        return jarFile.getParentFile();
    }

    public static File getProfileArchive(String profile, File directory) {
        File profileDirectory;
        String name = profile;
        if (!name.startsWith("profile-")) {
            name = "profile-" + name;
        }
        if (!(profileDirectory = new File(directory, name)).exists()) {
            throw new FabricException("Profile not found in repository: " + profile);
        }
        File profileArchiveDirectory = new File(profileDirectory, "3.0.0");
        if (!profileArchiveDirectory.exists()) {
            profileArchiveDirectory = new File(profileDirectory, "3.0.0-SNAPSHOT");
        }
        if (!profileArchiveDirectory.exists()) {
            throw new FabricException("Profile version not found in repository: " + profile);
        }
        File profileArchive = new File(profileArchiveDirectory, name + "-" + "3.0.0" + "-bin.zip");
        if (!profileArchive.exists()) {
            profileArchive = new File(profileArchiveDirectory, name + "-" + "3.0.0" + "-SNAPSHOT-bin.zip");
        }
        if (!profileArchive.exists()) {
            throw new FabricException("Profile archive not found in repository: " + profile);
        }
        return profileArchive;
    }

    public static File getExtensionArchive(String extension, File directory) {
        File profileDirectory = new File(directory, extension);
        if (!profileDirectory.exists()) {
            throw new FabricException("Extension archive not found in repository: " + extension);
        }
        File profileArchiveDirectory = new File(profileDirectory, "3.0.0");
        if (!profileArchiveDirectory.exists()) {
            profileArchiveDirectory = new File(profileDirectory, "3.0.0-SNAPSHOT");
        }
        if (!profileArchiveDirectory.exists()) {
            throw new FabricException("Extension archive version not found in repository: " + extension);
        }
        File profileArchive = new File(profileArchiveDirectory, extension + "-" + "3.0.0" + ".jar");
        if (!profileArchive.exists()) {
            profileArchive = new File(profileArchiveDirectory, extension + "-" + "3.0.0" + "-SNAPSHOT.jar");
        }
        if (!profileArchive.exists()) {
            throw new FabricException("Extension archive not found in repository: " + extension);
        }
        return profileArchive;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<File> unpack(File archive, File destination) throws IOException {
        ArrayList<File> expandedFiles = new ArrayList<File>();
        String fileName = archive.toString();
        int pos = fileName.indexOf(".jar!");
        if (pos > 0) {
            try (InputStream stream = ArchiveUtils.class.getClassLoader().getResourceAsStream(fileName.substring(pos + 6));){
                File destinationFile = ArchiveUtils.getFile(stream, archive.getName(), destination);
                if (destinationFile == null) return expandedFiles;
                expandedFiles.addAll(ArchiveUtils.unpack(destinationFile, destination));
                return expandedFiles;
            }
        }
        try (JarInputStream stream = new JarInputStream(new FileInputStream(archive));){
            JarEntry entry;
            while ((entry = stream.getNextJarEntry()) != null) {
                String simpleName;
                File destinationFile;
                if (entry.isDirectory() || (destinationFile = ArchiveUtils.getFile(stream, simpleName = ArchiveUtils.parseSimpleName(entry), destination)) == null) continue;
                expandedFiles.add(destinationFile);
            }
            return expandedFiles;
        }
    }

    private static File getFile(InputStream stream, String name, File destination) throws IOException {
        if (name == null) {
            return null;
        }
        File jarFile = new File(destination, name);
        if (jarFile.exists()) {
            return null;
        }
        ArchiveUtils.copy(stream, jarFile);
        return jarFile;
    }

    private static String parseSimpleName(JarEntry entry) {
        int index = entry.getName().lastIndexOf("/");
        String simpleName = index > 0 ? entry.getName().substring(index) : entry.getName();
        if (!simpleName.endsWith(".jar") && !simpleName.endsWith(".zip")) {
            return null;
        }
        return simpleName;
    }

    private static void copy(InputStream stream, File destination) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(destination));){
            IOHelper.copy(stream, os);
            ((OutputStream)os).flush();
        }
        destination.deleteOnExit();
    }

    private static String getClassFileName(Class<?> clazz) {
        String name = clazz.getName();
        int last = name.lastIndexOf(46);
        if (last != -1) {
            name = name.substring(last + 1);
        }
        name = name + ".class";
        return name;
    }

    private ArchiveUtils() {
    }
}

