/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.node;

import java.lang.reflect.Field;
import org.fabric3.api.node.FabricException;

public class ClassLoaderUtils {
    public static void changeParentClassLoader(ClassLoader classLoader, ClassLoader newParent) {
        if ("dalvik".equalsIgnoreCase(System.getProperty("java.vm.name"))) {
            return;
        }
        try {
            Field parentField = ClassLoaderUtils.getParentClassLoaderField();
            parentField.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(parentField, parentField.getModifiers() & 0xFFFFFFEF);
            parentField.set(classLoader, newParent);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new FabricException("Unsupported VM", e);
        }
    }

    private static Field getParentClassLoaderField() {
        Field parentField;
        try {
            parentField = ClassLoader.class.getDeclaredField("parent");
        }
        catch (NoSuchFieldException e) {
            try {
                parentField = ClassLoader.class.getDeclaredField("parentClassLoader");
            }
            catch (NoSuchFieldException e1) {
                throw new FabricException("Unsupported VM", e);
            }
        }
        return parentField;
    }

    private ClassLoaderUtils() {
    }
}

