/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.node;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.Servlet;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.Names;
import org.fabric3.api.host.classloader.MaskingClassLoader;
import org.fabric3.api.host.contribution.ContributionSource;
import org.fabric3.api.host.contribution.FileContributionSource;
import org.fabric3.api.host.contribution.UrlContributionSource;
import org.fabric3.api.host.monitor.DelegatingDestinationRouter;
import org.fabric3.api.host.os.OperatingSystem;
import org.fabric3.api.host.runtime.BootConfiguration;
import org.fabric3.api.host.runtime.BootstrapFactory;
import org.fabric3.api.host.runtime.BootstrapHelper;
import org.fabric3.api.host.runtime.BootstrapService;
import org.fabric3.api.host.runtime.ComponentRegistration;
import org.fabric3.api.host.runtime.DefaultHostInfoBuilder;
import org.fabric3.api.host.runtime.Fabric3Runtime;
import org.fabric3.api.host.runtime.HiddenPackages;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.host.runtime.RuntimeConfiguration;
import org.fabric3.api.host.runtime.RuntimeCoordinator;
import org.fabric3.api.host.stream.UrlSource;
import org.fabric3.api.host.util.FileHelper;
import org.fabric3.api.model.type.RuntimeMode;
import org.fabric3.api.node.Domain;
import org.fabric3.api.node.Fabric;
import org.fabric3.api.node.FabricException;
import org.fabric3.node.ArchiveUtils;
import org.fabric3.node.ClassLoaderUtils;
import org.fabric3.node.FabricServletHost;
import org.fabric3.spi.host.ServletHost;
import org.w3c.dom.Document;

public class DefaultFabric
implements Fabric {
    private static final File SYNTHETIC_DIRECTORY = new File("notfound");
    public static final String ASM_PACKAGE = "org.objectweb.asm.";
    private URL configUrl;
    private File tempDirectory;
    private File extensionsDirectory;
    private File dataDirectory;
    private State state = State.UNINITIALIZED;
    private Fabric3Runtime runtime;
    private RuntimeCoordinator coordinator;
    private Domain domain;
    private Set<String> extensions = new HashSet<String>();
    private Set<URL> profileLocations = new HashSet<URL>();
    private Set<String> profiles = new HashSet<String>();
    private Set<URL> extensionLocations = new HashSet<URL>();
    private List<ComponentRegistration> registrations = new ArrayList<ComponentRegistration>();
    private FabricServletHost host;

    public DefaultFabric(URL configUrl) {
        this.configUrl = configUrl;
        String id = UUID.randomUUID().toString();
        this.tempDirectory = new File(System.getProperty("java.io.tmpdir"), ".f3-" + id);
        this.extensionsDirectory = new File(this.tempDirectory, "extensions");
        this.dataDirectory = new File(this.tempDirectory, "data");
        this.createDirectories();
    }

    @Override
    public Fabric addProfile(String name) {
        this.profiles.add(name);
        return this;
    }

    @Override
    public Fabric addProfile(URL location) {
        this.profileLocations.add(location);
        return this;
    }

    @Override
    public Fabric addExtension(String name) {
        this.extensions.add(name);
        return this;
    }

    @Override
    public Fabric addExtension(URL location) {
        this.extensionLocations.add(location);
        return this;
    }

    @Override
    public Fabric start() throws FabricException {
        this.startRuntime();
        this.startTransports();
        return this;
    }

    @Override
    public Fabric startRuntime() {
        if (this.state != State.UNINITIALIZED) {
            throw new IllegalStateException("In wrong state: " + (Object)((Object)this.state));
        }
        DelegatingDestinationRouter router = new DelegatingDestinationRouter();
        try {
            ClassLoader fabricClassLoader = this.getClass().getClassLoader();
            ClassLoader rootClassLoader = fabricClassLoader.getParent();
            MaskingClassLoader maskingClassLoader = new MaskingClassLoader(rootClassLoader, HiddenPackages.getPackages());
            ClassLoaderUtils.changeParentClassLoader(fabricClassLoader, maskingClassLoader);
            ClassLoader hostLoader = BootstrapHelper.createClassLoader(fabricClassLoader, SYNTHETIC_DIRECTORY);
            MaskingClassLoader maskingHostLoader = new MaskingClassLoader(hostLoader, ASM_PACKAGE);
            ClassLoader bootLoader = BootstrapHelper.createClassLoader(hostLoader, SYNTHETIC_DIRECTORY);
            MaskingClassLoader maskingBootLoader = new MaskingClassLoader(bootLoader, ASM_PACKAGE);
            BootstrapService bootstrapService = BootstrapFactory.getService(maskingBootLoader);
            UrlSource urlSource = this.resolveSystemConfiguration(this.configUrl);
            Document systemConfig = bootstrapService.loadSystemConfig(urlSource);
            URI domainName = bootstrapService.parseDomainName(systemConfig);
            RuntimeMode mode = bootstrapService.parseRuntimeMode(systemConfig);
            String environment = bootstrapService.parseEnvironment(systemConfig);
            String zoneName = bootstrapService.parseZoneName(systemConfig, mode);
            String defaultRuntimeName = UUID.randomUUID().toString();
            String runtimeName = bootstrapService.getRuntimeName(domainName, zoneName, defaultRuntimeName, mode);
            HostInfo hostInfo = this.createHostInfo(runtimeName, zoneName, mode, domainName, environment);
            RuntimeConfiguration runtimeConfig = new RuntimeConfiguration(hostInfo, null, router);
            this.runtime = bootstrapService.createDefaultRuntime(runtimeConfig);
            boolean onlyCore = this.profiles.isEmpty() && this.profileLocations.isEmpty() && this.extensionLocations.isEmpty() && this.extensions.isEmpty();
            ScannedExtensions scannedExtensions = this.scanExtensions(onlyCore);
            if (!onlyCore) {
                this.addConfiguredExtensions(scannedExtensions);
            }
            BootConfiguration configuration = new BootConfiguration();
            configuration.setRuntime(this.runtime);
            configuration.setHostClassLoader(maskingHostLoader);
            configuration.setBootClassLoader(maskingBootLoader);
            configuration.setSystemConfig(systemConfig);
            configuration.setExtensionContributions(scannedExtensions.sources);
            configuration.addRegistrations(this.registrations);
            this.coordinator = bootstrapService.createCoordinator(configuration);
            this.coordinator.boot();
            this.coordinator.load();
            this.coordinator.startRuntime();
            this.state = State.STARTED;
            return this;
        }
        catch (Exception e) {
            router.flush(System.out);
            throw new FabricException(e);
        }
    }

    @Override
    public Fabric startTransports() {
        if (this.state != State.STARTED) {
            throw new IllegalStateException("In wrong state: " + (Object)((Object)this.state));
        }
        this.coordinator.startTransports();
        this.state = State.RUNNING;
        return this;
    }

    @Override
    public Fabric stop() throws FabricException {
        block5: {
            if (this.state != State.RUNNING && this.state != State.STARTED) {
                throw new IllegalStateException("Not in started or running state: " + (Object)((Object)this.state));
            }
            this.coordinator.shutdown();
            this.state = State.UNINITIALIZED;
            if (this.tempDirectory.exists()) {
                try {
                    FileHelper.cleanDirectory(this.tempDirectory);
                }
                catch (Fabric3Exception e) {
                    if (e.getCause() instanceof IOException) {
                        // empty if block
                    }
                    if (!this.tempDirectory.exists()) break block5;
                    FileHelper.forceDeleteOnExit(this.tempDirectory);
                }
            }
        }
        return this;
    }

    @Override
    public <T> T createTransportDispatcher(Class<T> interfaze, Map<String, Object> properties) {
        if (this.state != State.UNINITIALIZED) {
            throw new IllegalStateException("Must be in the uninitialized state: " + (Object)((Object)this.state));
        }
        if (Servlet.class.isAssignableFrom(interfaze)) {
            if (this.host == null) {
                int httpPort = (Integer)properties.getOrDefault("http.port", 8080);
                int httpsPort = (Integer)properties.getOrDefault("https.port", 4242);
                URL httpUrl = (URL)properties.get("http.url");
                URL httpsUrl = (URL)properties.get("https.url");
                String contextPath = (String)properties.getOrDefault("http.context", "fabric3");
                this.host = new FabricServletHost(httpPort, httpsPort, httpUrl, httpsUrl, contextPath);
                this.registerSystemService(ServletHost.class, this.host);
            }
            return interfaze.cast(this.host);
        }
        return null;
    }

    @Override
    public <T> T getSystemService(Class<T> interfaze) {
        return this.runtime.getComponent(interfaze);
    }

    @Override
    public <T> Fabric registerSystemService(Class<T> interfaze, T instance) throws FabricException {
        ComponentRegistration registration = new ComponentRegistration(interfaze.getSimpleName(), interfaze, instance, false);
        this.registrations.add(registration);
        return this;
    }

    @Override
    public Domain getDomain() {
        if (this.state != State.RUNNING && this.state != State.STARTED) {
            throw new IllegalStateException("Not in started or running state: " + (Object)((Object)this.state));
        }
        if (this.domain == null) {
            this.domain = this.runtime.getComponent(Domain.class, Names.NODE_DOMAIN_URI);
        }
        return this.domain;
    }

    private void addConfiguredExtensions(ScannedExtensions scannedExtensions) throws IOException {
        File repositoryDirectory = ArchiveUtils.getJarDirectory(DefaultFabric.class).getParentFile().getParentFile();
        for (String profile : this.profiles) {
            boolean found = false;
            String name = profile.startsWith("profile-") ? profile : "profile-" + profile;
            for (File archive : scannedExtensions.profileArchives) {
                if (!archive.getName().startsWith(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            File profileArchive = ArchiveUtils.getProfileArchive(profile, repositoryDirectory);
            List<File> expanded = ArchiveUtils.unpack(profileArchive, this.extensionsDirectory);
            this.addSources(expanded, scannedExtensions.sources);
        }
        for (String extension : this.extensions) {
            File extensionArchive = ArchiveUtils.getExtensionArchive(extension, repositoryDirectory);
            URI uri = URI.create(extensionArchive.getName());
            URL location = extensionArchive.toURI().toURL();
            FileContributionSource source = new FileContributionSource(uri, location, -1L, true);
            scannedExtensions.sources.add(source);
        }
        this.addContributionSources(this.profileLocations, scannedExtensions.sources);
        this.addContributionSources(this.extensionLocations, scannedExtensions.sources);
    }

    private void addContributionSources(Set<URL> locations, List<ContributionSource> sources) {
        for (URL location : locations) {
            try {
                UrlContributionSource source = new UrlContributionSource(location.toURI(), location, false);
                sources.add(source);
            }
            catch (URISyntaxException e) {
                throw new FabricException(e);
            }
        }
    }

    private void createDirectories() throws FabricException {
        if (this.tempDirectory.exists()) {
            FileHelper.cleanDirectory(this.tempDirectory);
        }
        this.tempDirectory.mkdirs();
        this.extensionsDirectory.mkdirs();
        this.dataDirectory.mkdirs();
    }

    private UrlSource resolveSystemConfiguration(URL configUrl) {
        if (configUrl == null && (configUrl = this.getClass().getClassLoader().getResource("META-INF/f3.default.config.xml")) == null) {
            throw new FabricException("Default system configuration not found");
        }
        return new UrlSource(configUrl);
    }

    private File getRuntimeDirectory(RuntimeMode mode) {
        File jarDirectory = ArchiveUtils.getJarDirectory(DefaultFabric.class);
        File root = new File(jarDirectory, "runtimes");
        return new File(root, mode.toString().toLowerCase());
    }

    private HostInfo createHostInfo(String runtimeName, String zoneName, RuntimeMode mode, URI domainName, String environment) throws IOException {
        File runtimeDirectory = this.getRuntimeDirectory(mode);
        List<File> deployDirs = Collections.emptyList();
        OperatingSystem os = BootstrapHelper.getOperatingSystem();
        DefaultHostInfoBuilder builder = new DefaultHostInfoBuilder();
        builder.runtimeName(runtimeName);
        builder.zoneName(zoneName);
        builder.runtimeMode(mode);
        builder.environment(environment);
        builder.domain(domainName);
        builder.baseDir(runtimeDirectory);
        builder.sharedDirectory(SYNTHETIC_DIRECTORY);
        builder.dataDirectory(this.dataDirectory);
        builder.tempDirectory(this.tempDirectory);
        builder.deployDirectories(deployDirs);
        builder.operatingSystem(os);
        return builder.javaEEXAEnabled(false).build();
    }

    private ScannedExtensions scanExtensions(boolean onlyCore) throws Fabric3Exception {
        File repositoryDirectory = ArchiveUtils.getJarDirectory(DefaultFabric.class);
        File f3Extensions = new File(repositoryDirectory, "f3.extensions.jar");
        try {
            List<File> archives = this.scanClasspathForProfileArchives();
            if (archives.size() == 0) {
                throw new Fabric3Exception("Core extension archive not found");
            }
            ArrayList<ContributionSource> sources = new ArrayList<ContributionSource>();
            ArrayList<File> extensionsFiles = new ArrayList<File>();
            for (File extension : archives) {
                if ((onlyCore || f3Extensions.exists()) && !extension.getName().contains("fabric3-node-extensions")) continue;
                extensionsFiles.addAll(ArchiveUtils.unpack(extension, this.extensionsDirectory));
            }
            if (f3Extensions.exists()) {
                List<File> files = ArchiveUtils.unpack(f3Extensions, this.extensionsDirectory);
                for (File file : files) {
                    extensionsFiles.add(file);
                }
            }
            this.addSources(extensionsFiles, sources);
            return new ScannedExtensions(archives, sources);
        }
        catch (IOException e) {
            throw new Fabric3Exception("Error scanning extensions", e);
        }
    }

    private void addSources(List<File> files, List<ContributionSource> sources) throws MalformedURLException {
        for (File file : files) {
            URL location = file.toURI().toURL();
            if (file.isDirectory()) continue;
            URI uri = URI.create(file.getName());
            FileContributionSource source = new FileContributionSource(uri, location, -1L, true);
            sources.add(source);
        }
    }

    private List<File> scanClasspathForProfileArchives() throws IOException {
        Enumeration<URL> manifests = this.getClass().getClassLoader().getResources("extensions/F3-MANIFEST.MF");
        ArrayList<File> extensionFiles = new ArrayList<File>();
        while (manifests.hasMoreElements()) {
            URL manifest = manifests.nextElement();
            String path = manifest.getPath();
            if (path.startsWith("file:")) {
                path = path.substring(5);
            }
            path = path.substring(0, path.length() - 27);
            extensionFiles.add(new File(path));
        }
        return extensionFiles;
    }

    private class ScannedExtensions {
        List<File> profileArchives;
        List<ContributionSource> sources;

        public ScannedExtensions(List<File> profileArchives, List<ContributionSource> sources) {
            this.profileArchives = profileArchives;
            this.sources = sources;
        }
    }

    private static enum State {
        UNINITIALIZED,
        STARTED,
        RUNNING;

    }
}

