/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.node;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fabric3.spi.host.ServletHost;

public class FabricServletHost
extends HttpServlet
implements ServletHost {
    private static final long serialVersionUID = -9146911758634764053L;
    private int http;
    private int https;
    private URL baseUrl;
    private URL baseHttpsUrl;
    private String contextPath;
    private transient ServletConfig config;
    private transient Map<String, Servlet> servlets = new ConcurrentHashMap<String, Servlet>();
    private AtomicBoolean initialized = new AtomicBoolean();

    public FabricServletHost(int http, int https, URL baseUrl, URL baseHttpsUrl, String contextPath) {
        this.http = http;
        this.https = https;
        this.baseUrl = baseUrl;
        this.baseHttpsUrl = baseHttpsUrl;
        this.contextPath = contextPath;
    }

    @Override
    public String getHostType() {
        return "fabric";
    }

    @Override
    public int getHttpPort() {
        return this.http;
    }

    @Override
    public int getHttpsPort() {
        return this.https;
    }

    @Override
    public URL getBaseHttpUrl() {
        return this.baseUrl;
    }

    @Override
    public URL getBaseHttpsUrl() {
        return this.baseHttpsUrl;
    }

    @Override
    public boolean isHttpsEnabled() {
        return this.https != -1;
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        for (Servlet servlet : this.servlets.values()) {
            servlet.init(config);
        }
        this.config = config;
        this.initialized.set(true);
    }

    @Override
    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = req.getPathInfo();
        if (path == null) {
            this.notFound(resp);
            return;
        }
        Servlet servlet = this.servlets.get(path);
        if (servlet == null) {
            servlet = this.servlets.get(path + "/*");
            if (servlet == null) {
                int i;
                while ((i = path.lastIndexOf("/")) >= 0 && (servlet = this.servlets.get(path.substring(0, i) + "/*")) == null) {
                    path = path.substring(0, i);
                }
            }
            if (servlet == null) {
                this.notFound(resp);
                return;
            }
        }
        servlet.service(req, resp);
    }

    @Override
    public void registerMapping(String path, Servlet servlet) {
        if (this.servlets.containsKey(path)) {
            throw new IllegalStateException("Servlet already registered at path: " + path);
        }
        if (this.initialized.get()) {
            try {
                servlet.init(this.config);
            }
            catch (ServletException e) {
                this.log("Error initializing servlet for path: " + path, e);
            }
        }
        this.servlets.put(path, servlet);
    }

    @Override
    public boolean isMappingRegistered(String mapping) {
        return this.servlets.containsKey(mapping);
    }

    @Override
    public Servlet unregisterMapping(String path) {
        return this.servlets.remove(path);
    }

    private void notFound(HttpServletResponse resp) throws IOException {
        resp.setStatus(404);
        PrintWriter writer = resp.getWriter();
        writer.print("Resource not found");
        writer.close();
    }
}

