/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.security.impl;

import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import org.fabric3.api.SecuritySubject;
import org.fabric3.security.impl.InvalidAuthenticationException;
import org.fabric3.security.impl.SecurityStore;
import org.fabric3.spi.security.AuthenticationException;
import org.fabric3.spi.security.AuthenticationService;
import org.fabric3.spi.security.AuthenticationToken;
import org.fabric3.spi.security.BasicSecuritySubject;
import org.fabric3.spi.security.UsernamePasswordToken;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;
import org.oasisopen.sca.annotation.Service;

@Service(value={AuthenticationService.class, JMXAuthenticator.class})
@EagerInit
public class AuthenticationServiceImpl
implements AuthenticationService,
JMXAuthenticator {
    private SecurityStore store;

    public AuthenticationServiceImpl(@Reference SecurityStore store) {
        this.store = store;
    }

    @Override
    public SecuritySubject authenticate(AuthenticationToken<?, ?> token) throws AuthenticationException {
        if (token == null) {
            throw new IllegalArgumentException("Null token");
        }
        if (!(token instanceof UsernamePasswordToken)) {
            throw new UnsupportedOperationException("Token type not supported: " + token.getClass().getName());
        }
        UsernamePasswordToken userToken = (UsernamePasswordToken)token;
        String principal = userToken.getPrincipal();
        if (principal == null) {
            throw new AuthenticationException("Principal was null");
        }
        BasicSecuritySubject subject = this.store.find(principal);
        if (subject == null) {
            throw new InvalidAuthenticationException("Invalid authentication information");
        }
        if (!userToken.getCredentials().equals(subject.getPassword())) {
            throw new InvalidAuthenticationException("Invalid authentication information");
        }
        return subject;
    }

    @Override
    public Subject authenticate(Object credentials) {
        if (!(credentials instanceof String[])) {
            if (credentials == null) {
                throw new SecurityException("Credentials were null");
            }
            throw new SecurityException("Credentials must be a String[]");
        }
        String[] params = (String[])credentials;
        if (params.length != 2) {
            throw new SecurityException("Credentials must consist of a username and password");
        }
        UsernamePasswordToken token = new UsernamePasswordToken(params[0], params[1]);
        try {
            SecuritySubject subject = this.authenticate(token);
            return subject.getJaasSubject();
        }
        catch (AuthenticationException e) {
            throw new SecurityException(e);
        }
    }
}

