/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.contribution.manifest;

import org.fabric3.api.host.Version;
import org.fabric3.spi.model.version.Versionable;

public final class PackageInfo
extends Versionable {
    private static final long serialVersionUID = 1011714148953772009L;
    private String name;
    private boolean required;
    private String[] packageNames;

    public PackageInfo(String name, Version minVersion, boolean minInclusive, Version maxVersion, boolean maxInclusive, boolean required) {
        super(minVersion, minInclusive, maxVersion, maxInclusive);
        this.setName(name);
        this.required = required;
    }

    public PackageInfo(String name, Version version, boolean minInclusive, boolean required) {
        super(version, minInclusive);
        this.setName(name);
        this.required = required;
    }

    public PackageInfo(String name) {
        this.setName(name);
        this.required = true;
    }

    public PackageInfo(String name, Version version) {
        super(version);
        this.setName(name);
    }

    public PackageInfo(String name, boolean required) {
        this.setName(name);
        this.required = required;
    }

    public PackageInfo() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.packageNames = name.split("\\.");
    }

    @Override
    public Version getMinVersion() {
        return this.minVersion;
    }

    @Override
    public void setMinVersion(Version minVersion) {
        this.minVersion = minVersion;
    }

    @Override
    public boolean isMinInclusive() {
        return this.minInclusive;
    }

    @Override
    public void setMinInclusive(boolean minInclusive) {
        this.minInclusive = minInclusive;
    }

    @Override
    public Version getMaxVersion() {
        return this.maxVersion;
    }

    @Override
    public void setMaxVersion(Version maxVersion) {
        this.maxVersion = maxVersion;
    }

    @Override
    public boolean isMaxInclusive() {
        return this.maxInclusive;
    }

    @Override
    public void setMaxInclusive(boolean maxInclusive) {
        this.maxInclusive = maxInclusive;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean matches(PackageInfo exportPackage) {
        if (!super.matches(exportPackage.getMinVersion())) {
            return false;
        }
        int i = 0;
        boolean exportWildcard = exportPackage.packageNames[exportPackage.packageNames.length - 1].equals("*");
        if (this.packageNames.length < exportPackage.packageNames.length && !"*".equals(this.packageNames[this.packageNames.length - 1]) && !exportWildcard) {
            return false;
        }
        for (String packageName : exportPackage.packageNames) {
            if ("*".equals(packageName)) {
                return true;
            }
            if (this.packageNames.length - 1 >= i && !packageName.equals(this.packageNames[i])) {
                return false;
            }
            if (this.packageNames.length - 1 != ++i || this.packageNames.length <= exportPackage.packageNames.length || "*".equals(this.packageNames[i])) continue;
            return false;
        }
        if (this.packageNames.length > 0 && "*".equals(this.packageNames[this.packageNames.length - 1])) {
            return exportPackage.packageNames.length == this.packageNames.length - 1;
        }
        return exportPackage.packageNames.length == this.packageNames.length;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.minVersion != null ? this.minVersion.hashCode() : 0);
        result = 31 * result + (this.maxVersion != null ? this.maxVersion.hashCode() : 0);
        result = 31 * result + (this.required ? 1 : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("package: " + this.name);
        if (this.minVersion != null) {
            builder.append(" Min: ").append(this.minVersion);
        }
        if (this.maxVersion != null) {
            builder.append(" Max: ").append(this.maxVersion);
        }
        builder.append(" Required: ").append(this.required);
        return builder.toString();
    }
}

