/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.introspection.java;

import java.lang.reflect.Member;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.java.InjectableType;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.spi.introspection.java.JavaValidationFailure;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.MethodInjectionSite;

public class UnknownInjectionType
extends JavaValidationFailure {
    private InjectionSite site;
    private InjectableType type;
    private String clazz;

    public UnknownInjectionType(InjectionSite site, InjectableType type, String clazz, Member member, ComponentType componentType) {
        super(member, componentType);
        this.site = site;
        this.type = type;
        this.clazz = clazz;
    }

    public String getImplementationClass() {
        return this.clazz;
    }

    @Override
    public String getMessage() {
        if (this.site instanceof FieldInjectionSite) {
            FieldInjectionSite field = (FieldInjectionSite)this.site;
            return "Unknown injection type " + (Object)((Object)this.type) + " on field " + field.getName() + " in class " + this.clazz;
        }
        if (this.site instanceof MethodInjectionSite) {
            MethodInjectionSite method = (MethodInjectionSite)this.site;
            return "Unknown injection type " + (Object)((Object)this.type) + " on method " + method + " in class " + this.clazz;
        }
        if (this.site instanceof ConstructorInjectionSite) {
            ConstructorInjectionSite ctor = (ConstructorInjectionSite)this.site;
            return "Unknown injection type " + (Object)((Object)this.type) + " on constructor " + ctor.getConstructor() + " in class " + this.clazz;
        }
        return "Unknown injection type " + (Object)((Object)this.type) + " found in class " + this.clazz;
    }
}

