/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.instance;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.Implementation;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalProducer;
import org.fabric3.spi.model.instance.LogicalProperty;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalResourceReference;
import org.fabric3.spi.model.instance.LogicalScaArtifact;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalState;

public class LogicalComponent<I extends Implementation<?>>
extends LogicalScaArtifact<LogicalCompositeComponent> {
    private static final long serialVersionUID = -3520150701040845117L;
    private URI uri;
    private Component<I> definition;
    private Map<String, LogicalProperty> properties = new HashMap<String, LogicalProperty>();
    private Map<String, LogicalService> services = new HashMap<String, LogicalService>();
    private Map<String, LogicalReference> references = new HashMap<String, LogicalReference>();
    private Map<String, LogicalProducer> producers = new HashMap<String, LogicalProducer>();
    private Map<String, LogicalConsumer> consumers = new HashMap<String, LogicalConsumer>();
    private Map<String, LogicalResourceReference<?>> resourceReferences = new HashMap();
    private LogicalState state = LogicalState.NEW;

    public LogicalComponent(URI uri, Component<I> definition, LogicalCompositeComponent parent) {
        super(parent);
        this.uri = uri;
        this.definition = definition;
    }

    public URI getUri() {
        return this.uri;
    }

    public Collection<LogicalService> getServices() {
        return this.services.values();
    }

    public LogicalService getService(String name) {
        return this.services.get(name);
    }

    public void addService(LogicalService service) {
        this.services.put(service.getUri().getFragment(), service);
    }

    public Collection<LogicalResourceReference<?>> getResourceReferences() {
        return this.resourceReferences.values();
    }

    public LogicalResourceReference<?> getResourceReference(String name) {
        return this.resourceReferences.get(name);
    }

    public void addResource(LogicalResourceReference<?> resourceReference) {
        this.resourceReferences.put(resourceReference.getUri().getFragment(), resourceReference);
    }

    public Collection<LogicalReference> getReferences() {
        return this.references.values();
    }

    public LogicalReference getReference(String name) {
        return this.references.get(name);
    }

    public void addReference(LogicalReference reference) {
        this.references.put(reference.getUri().getFragment(), reference);
    }

    public Collection<LogicalProducer> getProducers() {
        return this.producers.values();
    }

    public LogicalProducer getProducer(String name) {
        return this.producers.get(name);
    }

    public void addProducer(LogicalProducer producer) {
        this.producers.put(producer.getUri().getFragment(), producer);
    }

    public Collection<LogicalConsumer> getConsumers() {
        return this.consumers.values();
    }

    public LogicalConsumer getConsumer(String name) {
        return this.consumers.get(name);
    }

    public void addConsumer(LogicalConsumer consumer) {
        this.consumers.put(consumer.getUri().getFragment(), consumer);
    }

    public Map<String, LogicalProperty> getAllProperties() {
        return this.properties;
    }

    public LogicalProperty getProperties(String name) {
        return this.properties.get(name);
    }

    public void setProperties(LogicalProperty property) {
        this.properties.put(property.getName(), property);
    }

    public Component<I> getDefinition() {
        return this.definition;
    }

    public LogicalState getState() {
        return this.state;
    }

    public void setState(LogicalState state) {
        this.state = state;
    }
}

