/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.instance;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.component.Producer;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalInvocable;
import org.fabric3.spi.model.instance.LogicalOperation;

public class LogicalProducer
extends LogicalInvocable {
    private static final long serialVersionUID = 5403855901902189810L;
    private Producer definition;
    private List<URI> targets;

    public LogicalProducer(URI uri, Producer definition, LogicalComponent<?> parent) {
        super(uri, definition != null ? definition.getServiceContract() : null, parent);
        this.definition = definition;
        this.targets = new ArrayList<URI>();
    }

    public Producer getDefinition() {
        return this.definition;
    }

    public List<URI> getTargets() {
        return this.targets;
    }

    public void addTarget(URI uri) {
        this.targets.add(uri);
    }

    public void addTargets(List<URI> targets) {
        this.targets.addAll(targets);
    }

    public LogicalOperation getStreamOperation() {
        if (this.operations.size() != 1) {
            throw new Fabric3Exception("Invalid number of operations on producer: " + this.getUri() + ". Producers that are not direct connections to channels may only have one operation.");
        }
        return (LogicalOperation)this.operations.get(0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LogicalProducer test = (LogicalProducer)obj;
        return this.getUri().equals(test.getUri());
    }

    public int hashCode() {
        return this.getUri().hashCode();
    }
}

