/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.instance;

import javax.xml.namespace.QName;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalScaArtifact;
import org.w3c.dom.Document;

public class LogicalProperty
extends LogicalScaArtifact<LogicalComponent<?>> {
    private static final long serialVersionUID = 4648573312983221666L;
    private String name;
    private Document xmlValue;
    private Object instanceValue;
    private String key;
    private boolean many;
    private QName type;
    private boolean required = true;

    public String getName() {
        return this.name;
    }

    public Document getXmlValue() {
        return this.xmlValue;
    }

    public Object getInstanceValue() {
        return this.instanceValue;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isMany() {
        return this.many;
    }

    public QName getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    private LogicalProperty(String name, LogicalComponent<?> parent) {
        super(parent);
        this.name = name;
    }

    public static class Builder {
        private LogicalProperty property;

        public static Builder newBuilder(String name, LogicalComponent<?> parent) {
            return new Builder(name, parent);
        }

        public Builder xmlValue(Document value) {
            this.property.xmlValue = value;
            return this;
        }

        public Builder type(QName type) {
            this.property.type = type;
            return this;
        }

        public Builder many(boolean value) {
            this.property.many = value;
            return this;
        }

        public Builder required(boolean value) {
            this.property.required = value;
            return this;
        }

        public Builder instanceValue(Object value) {
            this.property.instanceValue = value;
            return this;
        }

        public Builder key(String key) {
            this.property.key = key;
            return this;
        }

        public LogicalProperty build() {
            return this.property;
        }

        private Builder(String name, LogicalComponent<?> parent) {
            this.property = new LogicalProperty(name, parent);
            this.property.name = name;
        }
    }
}

