/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.instance;

import java.net.URI;
import java.util.List;
import org.fabric3.api.model.type.component.Component;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Reference;
import org.fabric3.spi.model.instance.LogicalBindable;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalWire;

public class LogicalReference
extends LogicalBindable {
    private static final long serialVersionUID = 2308698868251298609L;
    private Reference<ComponentType> definition;
    private boolean resolved;

    public LogicalReference(URI uri, Reference<ComponentType> definition, LogicalComponent<?> parent) {
        super(uri, definition != null ? definition.getServiceContract() : null, parent);
        this.definition = definition;
    }

    public Reference<ComponentType> getDefinition() {
        return this.definition;
    }

    public List<LogicalWire> getWires() {
        return this.getComposite().getWires(this);
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public Reference<Component> getComponentReference() {
        return ((LogicalComponent)this.getParent()).getDefinition().getReferences().get(this.getDefinition().getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LogicalReference test = (LogicalReference)obj;
        return this.getUri().equals(test.getUri());
    }

    public int hashCode() {
        return this.getUri().hashCode();
    }

    private LogicalCompositeComponent getComposite() {
        LogicalComponent parent = (LogicalComponent)this.getParent();
        LogicalCompositeComponent composite = (LogicalCompositeComponent)parent.getParent();
        return composite != null ? composite : (LogicalCompositeComponent)parent;
    }
}

