/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.instance;

import java.net.URI;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalScaArtifact;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalState;

public class LogicalWire
extends LogicalScaArtifact<LogicalComponent<?>> {
    private static final long serialVersionUID = -643283191171197255L;
    private LogicalReference source;
    private LogicalService target;
    private URI contributionUri;
    private LogicalBinding sourceBinding;
    private LogicalBinding targetBinding;
    private LogicalState state = LogicalState.NEW;

    public LogicalWire(LogicalComponent<?> parent, LogicalReference source, LogicalService target, URI contributionUri) {
        super(parent);
        this.source = source;
        this.target = target;
        this.contributionUri = contributionUri;
    }

    public LogicalReference getSource() {
        return this.source;
    }

    public LogicalService getTarget() {
        return this.target;
    }

    public LogicalState getState() {
        return this.state;
    }

    public void setState(LogicalState state) {
        this.state = state;
    }

    public URI getTargetContribution() {
        return this.contributionUri;
    }

    public LogicalBinding getSourceBinding() {
        return this.sourceBinding;
    }

    public void setSourceBinding(LogicalBinding sourceBinding) {
        this.sourceBinding = sourceBinding;
    }

    public LogicalBinding getTargetBinding() {
        return this.targetBinding;
    }

    public void setTargetBinding(LogicalBinding targetBinding) {
        this.targetBinding = targetBinding;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LogicalWire test = (LogicalWire)obj;
        return this.target.equals(test.target) && this.source.equals(test.source);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.source.hashCode();
        hash = 31 * hash + this.target.hashCode();
        return hash;
    }
}

