/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.threadpool;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.fabric3.spi.container.invocation.Fabric3Thread;
import org.fabric3.threadpool.ExecutorMonitor;

public class RuntimeThreadFactory
implements ThreadFactory {
    private AtomicInteger number = new AtomicInteger(1);
    private ThreadGroup group;
    private String prefix;
    private RuntimeUncaughtExceptionHandler handler;

    public RuntimeThreadFactory(ExecutorMonitor monitor) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.prefix = "pooled:";
        this.handler = new RuntimeUncaughtExceptionHandler(monitor);
    }

    @Override
    public Thread newThread(Runnable r) {
        Fabric3Thread thread = new Fabric3Thread(this.group, r, this.prefix + this.number.getAndIncrement(), 0L);
        if (thread.isDaemon()) {
            thread.setDaemon(false);
        }
        if (thread.getPriority() != 5) {
            thread.setPriority(5);
        }
        thread.setUncaughtExceptionHandler(this.handler);
        return thread;
    }

    private class RuntimeUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private ExecutorMonitor monitor;

        private RuntimeUncaughtExceptionHandler(ExecutorMonitor monitor) {
            this.monitor = monitor;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.monitor.threadError(e);
        }
    }
}

