/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.threadpool;

import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.fabric3.api.annotation.Source;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.threadpool.ExecutorMonitor;
import org.fabric3.threadpool.RuntimeThreadFactory;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;

@EagerInit
@Management(name="RuntimeThreadPoolExecutor", path="/runtime/threadpool", group="kernel", description="Manages the runtime thread pool")
public class RuntimeThreadPoolExecutor
extends AbstractExecutorService {
    private int coreSize = 100;
    private long keepAliveTime = 60000L;
    private boolean allowCoreThreadTimeOut = true;
    private int maximumSize = 100;
    private int queueSize = 10000;
    private RejectedExecutionHandler rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy();
    private ThreadPoolExecutor delegate;
    private LinkedBlockingQueue<Runnable> queue;
    private ExecutorMonitor monitor;

    @Property(required=false)
    @Source(value="$systemConfig//f3:thread.pool/@coreSize")
    public void setCoreSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Core pool size must be greater than or equal to 0");
        }
        this.coreSize = size;
    }

    @Property(required=false)
    @Source(value="$systemConfig//f3:thread.pool/@size")
    public void setMaximumSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("The MaximumSize pool size must be greater than or equal to 0");
        }
        this.maximumSize = size;
    }

    @Property(required=false)
    @Source(value="$systemConfig//f3:thread.pool/@queueSize")
    public void setQueueSize(int size) {
        this.queueSize = size;
    }

    @Property(required=false)
    @Source(value="$systemConfig//f3:thread.pool/@rejected.execution.handler")
    public void setRejectedExecutionHandler(String handler) {
        if ("abort".equals(handler)) {
            this.rejectedExecutionHandler = new ThreadPoolExecutor.AbortPolicy();
        } else if ("discard".equals(handler)) {
            this.rejectedExecutionHandler = new ThreadPoolExecutor.DiscardPolicy();
        } else if ("discard.oldest".equals(handler)) {
            this.rejectedExecutionHandler = new ThreadPoolExecutor.DiscardOldestPolicy();
        } else if (!"caller.runs".equals(handler)) {
            this.monitor.error("Invalid rejected execution handler configuration - setting to caller.runs: " + handler);
        }
    }

    @ManagementOperation(description="Thread keep alive time in milliseconds")
    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    @ManagementOperation(description="Thread keep alive time in milliseconds")
    @Property(required=false)
    @Source(value="$systemConfig//f3:thread.pool/@keepAliveTime")
    public void setKeepAliveTime(long keepAliveTime) {
        if (keepAliveTime < 0L) {
            throw new IllegalArgumentException("Keep alive time must be greater than or equal to 0");
        }
        this.keepAliveTime = keepAliveTime;
    }

    @ManagementOperation(description="True if the thread pool expires core threads")
    public boolean isAllowCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    @ManagementOperation(description="True if the thread pool expires core threads")
    @Property(required=false)
    @Source(value="$systemConfig//f3:thread.pool/@allowCoreThreadTimeOut")
    public void setAllowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
    }

    @ManagementOperation(description="Returns the approximate number of threads actively executing tasks")
    public int getActiveCount() {
        return this.delegate.getActiveCount();
    }

    @ManagementOperation(description="The maximum thread pool size")
    public int getMaximumPoolSize() {
        return this.delegate.getMaximumPoolSize();
    }

    @ManagementOperation(description="The maximum thread pool size")
    public void setMaximumPoolSize(int size) {
        this.delegate.setMaximumPoolSize(size);
    }

    @ManagementOperation(description="The core thread pool size")
    public int getCorePoolSize() {
        return this.delegate.getCorePoolSize();
    }

    @ManagementOperation(description="The core thread pool size")
    public void setCorePoolSize(int size) {
        this.delegate.setCorePoolSize(size);
    }

    @ManagementOperation(description="Returns the largest size the thread pool reached")
    public int getLargestPoolSize() {
        return this.delegate.getLargestPoolSize();
    }

    @ManagementOperation(description="Returns the remaining capacity the receive queue has before additional work will be rejected")
    public int getRemainingCapacity() {
        return this.queue.remainingCapacity();
    }

    public RuntimeThreadPoolExecutor(@Monitor ExecutorMonitor monitor) {
        this.monitor = monitor;
    }

    @Init
    public void init() {
        if (this.maximumSize < this.coreSize) {
            throw new IllegalArgumentException("Maximum pool size cannot be less than core pool size");
        }
        this.queue = this.queueSize > 0 ? new LinkedBlockingQueue(this.queueSize) : new LinkedBlockingQueue();
        RuntimeThreadFactory factory = new RuntimeThreadFactory(this.monitor);
        this.delegate = new ThreadPoolExecutor(this.coreSize, this.maximumSize, Long.MAX_VALUE, TimeUnit.SECONDS, this.queue, factory);
        this.delegate.setKeepAliveTime(this.keepAliveTime, TimeUnit.MILLISECONDS);
        this.delegate.allowCoreThreadTimeOut(this.allowCoreThreadTimeOut);
        this.delegate.setRejectedExecutionHandler(this.rejectedExecutionHandler);
    }

    @Destroy
    public void stop() {
        this.delegate.shutdown();
    }

    @Override
    public void execute(Runnable runnable) {
        this.delegate.execute(runnable);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }
}

