/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.transform.java;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.spi.classloader.ClassLoaderObjectInputStream;
import org.fabric3.spi.transform.Transformer;

public abstract class AbstractSerializingTransformer<S, T>
implements Transformer<S, T> {
    protected byte[] serialize(Object o) throws Fabric3Exception {
        if (o == null) {
            throw new IllegalArgumentException("Attempt to serialize a null object");
        }
        if (!(o instanceof Serializable)) {
            throw new IllegalArgumentException("Parameters for Java-to-Java transformations must implement Serializable: " + o.getClass());
        }
        ObjectOutputStream stream = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            stream = new ObjectOutputStream(bos);
            stream.writeObject(o);
            stream.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new Fabric3Exception(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected Serializable deserialize(byte[] bytes, ClassLoader loader) throws Fabric3Exception {
        ByteArrayInputStream bis = null;
        ObjectInputStream stream = null;
        try {
            bis = new ByteArrayInputStream(bytes);
            stream = new ClassLoaderObjectInputStream(bis, loader);
            Serializable serializable = (Serializable)stream.readObject();
            return serializable;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new Fabric3Exception(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

