/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.transform.property;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.spi.model.type.TypeConstants;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.transform.SingleTypeTransformer;
import org.w3c.dom.Node;

public class Property2DateTransformer
implements SingleTypeTransformer<Node, Date> {
    private static final JavaType TARGET = new JavaType(Date.class);
    private final DateFormat dateFormatter = new SimpleDateFormat("yyy-MM-d'T'HH:mm:ss'Z'");

    @Override
    public DataType getSourceType() {
        return TypeConstants.PROPERTY_TYPE;
    }

    @Override
    public DataType getTargetType() {
        return TARGET;
    }

    public Property2DateTransformer() {
        this.dateFormatter.setLenient(false);
    }

    @Override
    public Date transform(Node node, ClassLoader loader) throws Fabric3Exception {
        try {
            return this.dateFormatter.parse(node.getTextContent());
        }
        catch (ParseException pe) {
            throw new Fabric3Exception("Unsupported Date Format ", pe);
        }
    }
}

