/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.transform.property;

import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.spi.model.type.TypeConstants;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.transform.SingleTypeTransformer;
import org.w3c.dom.Node;

public class Property2LongTransformer
implements SingleTypeTransformer<Node, Long> {
    private static final JavaType TARGET = new JavaType(Long.class);

    @Override
    public DataType getSourceType() {
        return TypeConstants.PROPERTY_TYPE;
    }

    @Override
    public DataType getTargetType() {
        return TARGET;
    }

    @Override
    public Long transform(Node node, ClassLoader loader) throws Fabric3Exception {
        try {
            return Long.valueOf(node.getTextContent());
        }
        catch (NumberFormatException ex) {
            throw new Fabric3Exception("Unsupportable long " + node.getTextContent(), ex);
        }
    }
}

