/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.transform.property;

import java.util.Properties;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.spi.model.type.TypeConstants;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.transform.SingleTypeTransformer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Property2PropertiesTransformer
implements SingleTypeTransformer<Node, Properties> {
    private static final JavaType TARGET = new JavaType(Properties.class);

    @Override
    public DataType getSourceType() {
        return TypeConstants.PROPERTY_TYPE;
    }

    @Override
    public DataType getTargetType() {
        return TARGET;
    }

    @Override
    public Properties transform(Node node, ClassLoader loader) {
        Properties properties = new Properties();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (!(child instanceof Element)) continue;
            Element element = (Element)child;
            properties.put(element.getTagName(), child.getTextContent());
        }
        return properties;
    }
}

