/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.transform.property;

import javax.xml.namespace.QName;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.spi.model.type.TypeConstants;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.transform.SingleTypeTransformer;
import org.w3c.dom.Node;

public class Property2QNameTransformer
implements SingleTypeTransformer<Node, QName> {
    private static final JavaType TARGET = new JavaType(QName.class);

    @Override
    public DataType getSourceType() {
        return TypeConstants.PROPERTY_TYPE;
    }

    @Override
    public DataType getTargetType() {
        return TARGET;
    }

    @Override
    public QName transform(Node node, ClassLoader loader) throws Fabric3Exception {
        String prefix;
        String uri;
        String content = node.getTextContent();
        int index = content.indexOf(58);
        if (index != -1 && (uri = node.lookupNamespaceURI(prefix = content.substring(0, index))) != null) {
            String localPart = content.substring(index + 1);
            return new QName(uri, localPart, prefix);
        }
        return QName.valueOf(content);
    }
}

