/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.transform.property;

import java.net.MalformedURLException;
import java.net.URL;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.spi.model.type.TypeConstants;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.transform.SingleTypeTransformer;
import org.w3c.dom.Node;

public class Property2URLTransformer
implements SingleTypeTransformer<Node, URL> {
    private static final JavaType TARGET = new JavaType(URL.class);

    @Override
    public DataType getSourceType() {
        return TypeConstants.PROPERTY_TYPE;
    }

    @Override
    public DataType getTargetType() {
        return TARGET;
    }

    @Override
    public URL transform(Node node, ClassLoader loader) throws Fabric3Exception {
        URL url;
        String content = node.getTextContent();
        try {
            url = new URL(node.getTextContent());
        }
        catch (MalformedURLException me) {
            throw new Fabric3Exception("Unable to create URL :- " + content, me);
        }
        return url;
    }
}

