/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.plugin.deployer;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.fabric3.api.host.contribution.ValidationException;
import org.fabric3.api.host.domain.AssemblyException;
import org.fabric3.plugin.Fabric3PluginException;
import org.fabric3.plugin.api.runtime.PluginRuntime;

public abstract class AbstractDeployer {
    private String compositeNamespace;
    private String compositeName;
    private File buildDirectory;

    public AbstractDeployer(String compositeNamespace, String compositeName, File buildDirectory) {
        this.compositeNamespace = compositeNamespace;
        this.compositeName = compositeName;
        this.buildDirectory = buildDirectory;
    }

    public boolean deploy(PluginRuntime runtime, String errorText) throws Fabric3PluginException {
        try {
            QName qName = new QName(this.compositeNamespace, this.compositeName);
            URL buildDirUrl = this.getBuildDirectoryUrl();
            runtime.deploy(buildDirUrl, qName);
            return true;
        }
        catch (ValidationException e) {
            if (errorText != null && e.getMessage() != null && e.getMessage().contains(errorText)) {
                return false;
            }
            this.reportContributionErrors(e);
            String msg = "Contribution errors were found";
            throw new Fabric3PluginException(msg);
        }
        catch (AssemblyException e) {
            if (errorText != null && e.getMessage().contains(errorText)) {
                return false;
            }
            this.reportDeploymentErrors(e);
            String msg = "Deployment errors were found";
            throw new Fabric3PluginException(msg);
        }
        catch (Exception e) {
            if (errorText != null && e.getCause() != null && e.getCause().getMessage() != null && e.getCause().getMessage().contains(errorText)) {
                return false;
            }
            throw new Fabric3PluginException("Error deploying test composite", e);
        }
    }

    protected abstract void logError(String var1);

    private void reportContributionErrors(ValidationException cause) {
        StringBuilder b = new StringBuilder("\n\n");
        b.append("-------------------------------------------------------\n");
        b.append("CONTRIBUTION ERRORS\n");
        b.append("-------------------------------------------------------\n\n");
        b.append(cause.getMessage());
        this.logError(b.toString());
    }

    private void reportDeploymentErrors(AssemblyException cause) {
        StringBuilder b = new StringBuilder("\n\n");
        b.append("-------------------------------------------------------\n");
        b.append("DEPLOYMENT ERRORS\n");
        b.append("-------------------------------------------------------\n\n");
        b.append(cause.getMessage());
        this.logError(b.toString());
    }

    private URL getBuildDirectoryUrl() {
        try {
            return this.buildDirectory.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new AssertionError();
        }
    }
}

