/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.plugin.resolver;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.fabric3.api.host.contribution.ContributionSource;
import org.fabric3.api.host.contribution.FileContributionSource;
import org.fabric3.plugin.resolver.Dependencies;

public class Resolver {
    private RepositorySystem system;
    private RepositorySystemSession session;
    private List<RemoteRepository> repositories;
    private String runtimeVersion;

    public Resolver(RepositorySystem system, RepositorySystemSession session, List<RemoteRepository> repositories, String runtimeVersion) {
        this.system = system;
        this.session = session;
        this.repositories = repositories;
        this.runtimeVersion = runtimeVersion;
    }

    public Set<Artifact> resolveHostArtifacts(Set<Artifact> shared) throws DependencyResolutionException {
        HashSet<Artifact> hostArtifacts = new HashSet<Artifact>();
        Set<Artifact> hostDependencies = Dependencies.getHostDependencies(this.runtimeVersion);
        for (Artifact artifact : hostDependencies) {
            hostArtifacts.addAll(this.resolveTransitively(artifact));
        }
        if (shared != null) {
            for (Artifact artifact : shared) {
                hostArtifacts.addAll(this.resolveTransitively(artifact));
            }
        }
        return hostArtifacts;
    }

    public Set<Artifact> resolveRuntimeArtifacts() throws DependencyResolutionException {
        return this.resolveTransitively(Dependencies.getMainRuntimeModule(this.runtimeVersion));
    }

    public List<ContributionSource> resolveRuntimeExtensions(Set<Artifact> extensions, Set<Artifact> profiles) throws ArtifactResolutionException {
        HashSet<Artifact> expandedExtensions = new HashSet<Artifact>();
        expandedExtensions.addAll(Dependencies.getCoreExtensions(this.runtimeVersion));
        expandedExtensions.addAll(extensions);
        Set<Artifact> expandedProfiles = this.expandProfileExtensions(profiles);
        expandedExtensions.addAll(expandedProfiles);
        Set<URL> extensionUrls = this.resolve(expandedExtensions);
        return this.createContributionSources(extensionUrls);
    }

    public Set<URL> resolveDependencies(Set<Artifact> artifacts) throws DependencyResolutionException {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        for (Artifact dependency : artifacts) {
            try {
                Set<Artifact> resolved = this.resolveTransitively(dependency);
                for (Artifact artifact : resolved) {
                    File pathElement = artifact.getFile();
                    URL url = pathElement.toURI().toURL();
                    urls.add(url);
                }
            }
            catch (MalformedURLException e) {
                throw new DependencyResolutionException(null, (Throwable)e);
            }
        }
        return urls;
    }

    public Set<URL> resolve(Set<Artifact> artifacts) throws ArtifactResolutionException {
        HashSet<URL> urls = new HashSet<URL>();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                Artifact resolvedArtifact = this.resolveArtifact(artifact);
                try {
                    urls.add(resolvedArtifact.getFile().toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new AssertionError();
                }
            }
        }
        return urls;
    }

    public Set<Artifact> resolveTransitively(Artifact artifact) throws DependencyResolutionException {
        CollectRequest collectRequest = new CollectRequest();
        Dependency root = new Dependency(artifact, "compile");
        collectRequest.setRoot(root);
        collectRequest.setRepositories(this.repositories);
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, null);
        DependencyResult result = this.system.resolveDependencies(this.session, dependencyRequest);
        HashSet<Artifact> results = new HashSet<Artifact>();
        for (ArtifactResult artifactResult : result.getArtifactResults()) {
            Artifact dependency = artifactResult.getArtifact();
            results.add(dependency);
        }
        return results;
    }

    public Artifact resolveArtifact(Artifact artifact) throws ArtifactResolutionException {
        ArtifactRequest request = new ArtifactRequest(artifact, this.repositories, null);
        ArtifactResult result = this.system.resolveArtifact(this.session, request);
        return result.getArtifact();
    }

    private Set<Artifact> expandProfileExtensions(Set<Artifact> profiles) throws ArtifactResolutionException {
        HashSet<Artifact> dependencies = new HashSet<Artifact>();
        for (Artifact profile : profiles) {
            try {
                ArtifactDescriptorRequest request = new ArtifactDescriptorRequest();
                request.setArtifact(profile);
                request.setRepositories(this.repositories);
                ArtifactDescriptorResult result = this.system.readArtifactDescriptor(this.session, request);
                List exceptions = result.getExceptions();
                if (!exceptions.isEmpty()) {
                    Exception exception = (Exception)exceptions.get(0);
                    throw new ArtifactResolutionException(null, exception.getMessage(), (Throwable)exception);
                }
                for (Dependency dependency : result.getDependencies()) {
                    dependencies.add(dependency.getArtifact());
                }
            }
            catch (ArtifactDescriptorException e) {
                throw new ArtifactResolutionException(null, e.getMessage(), (Throwable)e);
            }
        }
        return dependencies;
    }

    private List<ContributionSource> createContributionSources(Set<URL> urls) {
        ArrayList<ContributionSource> sources = new ArrayList<ContributionSource>();
        for (URL extensionUrl : urls) {
            URI uri = URI.create(new File(extensionUrl.getFile()).getName());
            FileContributionSource source = new FileContributionSource(uri, extensionUrl, -1L, true);
            sources.add((ContributionSource)source);
        }
        return sources;
    }
}

