/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.plugin.runtime;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.fabric3.api.host.Fabric3Exception;
import org.fabric3.api.host.contribution.ContributionSource;
import org.fabric3.api.host.monitor.DestinationRouter;
import org.fabric3.api.host.runtime.BootConfiguration;
import org.fabric3.api.host.runtime.BootstrapFactory;
import org.fabric3.api.host.runtime.BootstrapService;
import org.fabric3.api.host.runtime.Fabric3Runtime;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.host.runtime.RuntimeCoordinator;
import org.fabric3.api.host.stream.InputStreamSource;
import org.fabric3.plugin.api.runtime.PluginHostInfo;
import org.fabric3.plugin.api.runtime.PluginRuntime;
import org.fabric3.plugin.api.runtime.PluginRuntimeConfiguration;
import org.fabric3.plugin.runtime.PluginBootConfiguration;
import org.w3c.dom.Document;

public abstract class AbstractPluginRuntimeBooter {
    private File buildDir;
    private File outputDirectory;
    private String systemConfig;
    private ClassLoader bootClassLoader;
    private ClassLoader hostClassLoader;
    private Set<URL> moduleDependencies;
    private RepositorySystem system;
    private RepositorySystemSession session;
    private DestinationRouter router;
    private RuntimeCoordinator coordinator;
    private List<ContributionSource> contributions;

    public AbstractPluginRuntimeBooter(PluginBootConfiguration configuration) {
        this.outputDirectory = configuration.getOutputDirectory();
        this.systemConfig = configuration.getSystemConfig();
        this.bootClassLoader = configuration.getBootClassLoader();
        this.hostClassLoader = configuration.getHostClassLoader();
        this.moduleDependencies = configuration.getModuleDependencies();
        this.contributions = configuration.getExtensions();
        this.system = configuration.getRepositorySystem();
        this.session = configuration.getRepositorySession();
        this.router = configuration.getRouter();
        this.buildDir = configuration.getBuildDir();
    }

    public PluginRuntime boot() throws Fabric3Exception {
        BootstrapService bootstrapService = BootstrapFactory.getService((ClassLoader)this.bootClassLoader);
        Document systemConfig = this.getSystemConfig(bootstrapService);
        PluginRuntime runtime = this.createRuntime(bootstrapService, systemConfig, this.buildDir);
        Map<String, String> exportedPackages = this.getExportedPackages();
        exportedPackages.put("org.fabric3.test.spi", "3.0.0");
        exportedPackages.put("org.fabric3.plugin.api", "3.0.0");
        exportedPackages.put("org.junit", "4.11");
        BootConfiguration configuration = new BootConfiguration();
        configuration.setRuntime((Fabric3Runtime)runtime);
        configuration.setHostClassLoader(this.hostClassLoader);
        configuration.setBootClassLoader(this.bootClassLoader);
        configuration.setSystemConfig(systemConfig);
        configuration.setExtensionContributions(this.contributions);
        configuration.setExportedPackages(exportedPackages);
        List registrations = bootstrapService.createDefaultRegistrations((Fabric3Runtime)runtime);
        configuration.addRegistrations(registrations);
        this.coordinator = bootstrapService.createCoordinator(configuration);
        this.coordinator.start();
        return runtime;
    }

    public void shutdown() throws Fabric3Exception, InterruptedException, ExecutionException {
        this.coordinator.shutdown();
    }

    protected abstract String getPluginClass();

    protected abstract Map<String, String> getExportedPackages();

    protected abstract PluginHostInfo createHostInfo(String var1, Set<URL> var2, File var3, File var4);

    private PluginRuntime createRuntime(BootstrapService bootstrapService, Document systemConfig, File buildDir) throws Fabric3Exception {
        String environment = bootstrapService.parseEnvironment(systemConfig);
        PluginHostInfo hostInfo = this.createHostInfo(environment, this.moduleDependencies, this.outputDirectory, buildDir);
        File tempDir = hostInfo.getTempDir();
        tempDir.mkdir();
        MBeanServer mBeanServer = MBeanServerFactory.createMBeanServer("fabric3://domain");
        PluginRuntimeConfiguration configuration = new PluginRuntimeConfiguration((HostInfo)hostInfo, mBeanServer, this.router, this.system, this.session);
        return this.instantiateRuntime(configuration, this.bootClassLoader);
    }

    private Document getSystemConfig(BootstrapService bootstrapService) throws Fabric3Exception {
        InputStreamSource source = null;
        if (this.systemConfig != null) {
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(this.systemConfig.getBytes("UTF-8"));
                source = new InputStreamSource("systemConfig", (InputStream)stream);
            }
            catch (UnsupportedEncodingException e) {
                throw new Fabric3Exception("Error loading system configuration", (Throwable)e);
            }
        }
        Document systemConfig = source == null ? bootstrapService.createDefaultSystemConfig() : bootstrapService.loadSystemConfig(source);
        return systemConfig;
    }

    private PluginRuntime instantiateRuntime(PluginRuntimeConfiguration configuration, ClassLoader cl) {
        try {
            Class<?> implClass = cl.loadClass(this.getPluginClass());
            return (PluginRuntime)PluginRuntime.class.cast(implClass.getConstructor(PluginRuntimeConfiguration.class).newInstance(configuration));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }
}

