/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.plugin.runtime;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fabric3.api.host.os.OperatingSystem;
import org.fabric3.api.model.type.RuntimeMode;
import org.fabric3.plugin.api.runtime.PluginHostInfo;

public class PluginHostInfoImpl
implements PluginHostInfo {
    private URI domain;
    private String environment;
    private Set<URL> dependencyUrls;
    private File tempDir;
    private File buildDir;
    private File classesDir;
    private File resourcesDir;
    private File testClassesDir;
    private File testResourcesDir;
    private File baseDir;
    private OperatingSystem operatingSystem;
    private File nativeDirectory;
    private List<Runnable> callbacks = new ArrayList<Runnable>();

    public PluginHostInfoImpl(URI domain, String environment, Set<URL> dependencyUrls, File baseDir, File tempDir, File buildDir, File classesDir, File resourcesDir, File testClassesDir, File testResourcesDir, OperatingSystem os) {
        this.domain = domain;
        this.environment = environment;
        this.dependencyUrls = dependencyUrls;
        this.baseDir = baseDir;
        this.tempDir = tempDir;
        this.buildDir = buildDir;
        this.classesDir = classesDir;
        this.resourcesDir = resourcesDir;
        this.testClassesDir = testClassesDir;
        this.testResourcesDir = testResourcesDir;
        this.nativeDirectory = new File(tempDir, "native");
        this.operatingSystem = os;
    }

    public String getRuntimeName() {
        return "plugin";
    }

    public String getZoneName() {
        return "LocalZone";
    }

    public String getEnvironment() {
        return this.environment;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public File getClassesDir() {
        return this.classesDir;
    }

    public File getResourcesDir() {
        return this.resourcesDir;
    }

    public File getTestClassesDir() {
        return this.testClassesDir;
    }

    public File getTestResourcesDir() {
        return this.testResourcesDir;
    }

    public File getNativeLibraryDir() {
        return this.nativeDirectory;
    }

    public File getDataDir() {
        return this.tempDir;
    }

    public File getExtensionsRepositoryDirectory() {
        return null;
    }

    public List<File> getDeployDirectories() {
        return Collections.emptyList();
    }

    public boolean supportsClassLoaderIsolation() {
        return true;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public RuntimeMode getRuntimeMode() {
        return RuntimeMode.VM;
    }

    public URI getDomain() {
        return this.domain;
    }

    public Set<URL> getDependencyUrls() {
        return this.dependencyUrls;
    }

    public File getBuildDir() {
        return this.buildDir;
    }

    public void addBootCallback(Runnable callback) {
        this.callbacks.add(callback);
    }

    public void notifyCallbacks() {
        this.callbacks.forEach(Runnable::run);
    }

    public boolean isJavaEEXAEnabled() {
        return false;
    }
}

