/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.plugin.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;
import org.fabric3.api.host.classloader.DelegatingResourceClassLoader;

public class ClassLoaderHelper {
    public static ClassLoader createBootClassLoader(ClassLoader parent, Set<Artifact> artifacts) {
        URL[] urls = new URL[artifacts.size()];
        int i = 0;
        for (Artifact artifact : artifacts) {
            File file = artifact.getFile();
            assert (file != null);
            try {
                urls[i++] = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        return new DelegatingResourceClassLoader(urls, parent);
    }

    public static ClassLoader createHostClassLoader(ClassLoader parent, Set<Artifact> hostArtifacts) {
        ArrayList<URL> urls = new ArrayList<URL>(hostArtifacts.size());
        for (Artifact artifact : hostArtifacts) {
            try {
                File pathElement = artifact.getFile();
                URL url = pathElement.toURI().toURL();
                urls.add(url);
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        return new DelegatingResourceClassLoader(urls.toArray(new URL[urls.size()]), parent);
    }
}

