/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.security.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.Role;
import org.fabric3.api.host.contribution.StoreException;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.security.impl.SecurityStore;
import org.fabric3.security.impl.SecurityStoreException;
import org.fabric3.spi.security.BasicSecuritySubject;
import org.fabric3.spi.xml.XMLFactory;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

public class FileSecurityStore
implements SecurityStore {
    private XMLInputFactory xmlFactory;
    private HostInfo info;
    private Map<String, BasicSecuritySubject> cache;

    public FileSecurityStore(@Reference XMLFactory xmlFactory, @Reference HostInfo info) {
        this.xmlFactory = xmlFactory.newInputFactoryInstance();
        this.info = info;
    }

    @Property(required=false)
    public void setSecurityConfiguration(XMLStreamReader reader) throws XMLStreamException, StoreException {
        this.cache = new ConcurrentHashMap<String, BasicSecuritySubject>();
        this.parse(reader);
    }

    @Init
    public void init() throws FileNotFoundException, XMLStreamException, StoreException {
        if (this.cache != null) {
            return;
        }
        this.cache = new ConcurrentHashMap<String, BasicSecuritySubject>();
        File dir = this.info.getBaseDir();
        if (dir == null) {
            return;
        }
        File securityFile = new File(dir, "config" + File.separator + "security.xml");
        if (!securityFile.exists()) {
            return;
        }
        FileInputStream fis = new FileInputStream(securityFile);
        BufferedInputStream buffered = new BufferedInputStream(fis);
        XMLStreamReader reader = this.xmlFactory.createXMLStreamReader(buffered);
        this.parse(reader);
    }

    @Override
    public BasicSecuritySubject find(String username) throws SecurityStoreException {
        return this.cache.get(username);
    }

    private void parse(XMLStreamReader reader) throws XMLStreamException, StoreException {
        reader.nextTag();
        String username = null;
        String password = null;
        Set<Object> roles = new HashSet<Role>();
        while (true) {
            switch (reader.next()) {
                case 1: {
                    if ("username".equals(reader.getName().getLocalPart())) {
                        username = reader.getElementText();
                        break;
                    }
                    if ("password".equals(reader.getName().getLocalPart())) {
                        password = reader.getElementText();
                        break;
                    }
                    if (!"roles".equals(reader.getName().getLocalPart())) break;
                    roles = this.parseRoles(reader, roles);
                    break;
                }
                case 8: {
                    return;
                }
                case 2: {
                    if (!"user".equals(reader.getName().getLocalPart())) break;
                    if (username == null) {
                        this.raiseInvalidConfiguration("Username is missing", reader);
                    }
                    if (password == null) {
                        this.raiseInvalidConfiguration("Password is missing", reader);
                    }
                    BasicSecuritySubject subject = new BasicSecuritySubject(username, password, roles);
                    this.cache.put(subject.getUsername(), subject);
                    username = null;
                    password = null;
                    roles = new HashSet();
                }
            }
        }
    }

    private Set<Role> parseRoles(XMLStreamReader reader, Set<Role> roles) throws XMLStreamException, StoreException {
        while (true) {
            switch (reader.next()) {
                case 1: {
                    if (!"role".equals(reader.getName().getLocalPart())) break;
                    Role role = new Role(reader.getElementText());
                    roles.add(role);
                    break;
                }
                case 8: {
                    this.raiseInvalidConfiguration("Invalid end of document", reader);
                }
                case 2: {
                    if (!"roles".equals(reader.getName().getLocalPart())) break;
                    return roles;
                }
            }
        }
    }

    private void raiseInvalidConfiguration(String message, XMLStreamReader reader) throws StoreException {
        Location location = reader.getLocation();
        if (location == null) {
            throw new StoreException(message);
        }
        int line = location.getLineNumber();
        int col = location.getColumnNumber();
        throw new StoreException(message + " [" + line + "," + col + "]");
    }
}

