/*
 * Fabric3
 * Copyright (c) 2009-2015 Metaform Systems
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Portions originally based on Apache Tuscany 2007
 * licensed under the Apache 2.0 license.
 */
package org.fabric3.spi.container.wire;

import org.fabric3.spi.model.physical.PhysicalOperation;

/**
 * A wire consists of 1..n invocation chains associated with the operations of its source service contract.
 *
 * Invocation chains contain <code>Interceptors</code> that process invocations in an around-style manner.
 */
public interface InvocationChain {

    /**
     * Returns the target physical operation for this invocation chain.
     *
     * @return the target physical operation for this invocation chain
     */
    PhysicalOperation getPhysicalOperation();

    /**
     * Adds an interceptor to the chain
     *
     * @param interceptor the interceptor to add
     */
    void addInterceptor(Interceptor interceptor);

    /**
     * Adds an interceptor at the given position in the interceptor stack
     *
     * @param index       the position in the interceptor stack to add the interceptor
     * @param interceptor the interceptor to add
     */
    void addInterceptor(int index, Interceptor interceptor);

    /**
     * Returns the first interceptor in the chain.
     *
     * @return the first interceptor in the chain
     */
    Interceptor getHeadInterceptor();

    /**
     * Returns the last interceptor in the chain.
     *
     * @return the last interceptor in the chain
     */
    Interceptor getTailInterceptor();

}
