/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.container.invocation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fabric3.api.host.Fabric3Exception;

public class CallbackReferenceSerializer {
    public static String serializeToString(List<String> references) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String reference : references) {
            if (first) {
                builder.append(reference);
                first = false;
                continue;
            }
            builder.append(",").append(reference);
        }
        return builder.toString();
    }

    public static byte[] serializeToBytes(List<String> references) throws Fabric3Exception {
        try {
            ByteArrayOutputStream bas = new ByteArrayOutputStream();
            DataOutputStream das = new DataOutputStream(bas);
            das.writeInt(references.size());
            for (String reference : references) {
                das.writeInt(reference.length());
                das.write(reference.getBytes());
            }
            return bas.toByteArray();
        }
        catch (IOException e) {
            throw new Fabric3Exception((Throwable)e);
        }
    }

    public static List<String> deserialize(byte[] bytes) throws Fabric3Exception {
        try {
            int number;
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            DataInputStream dis = new DataInputStream(bis);
            ArrayList<String> references = new ArrayList<String>(number);
            for (number = dis.readInt(); number > 0; --number) {
                String callbackReference = null;
                int callbackUriSize = dis.readInt();
                if (callbackUriSize > 0) {
                    byte[] uriBytes = new byte[callbackUriSize];
                    dis.read(uriBytes);
                    callbackReference = new String(uriBytes);
                }
                references.add(callbackReference);
            }
            return references;
        }
        catch (IOException e) {
            throw new Fabric3Exception((Throwable)e);
        }
    }

    public static List<String> deserialize(String serialized) {
        ArrayList<String> references = new ArrayList<String>();
        String[] tokens = serialized.split(",");
        Collections.addAll(references, tokens);
        return references;
    }
}

