/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.introspection.java;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.fabric3.api.annotation.model.BindingHandler;
import org.fabric3.api.host.runtime.HostInfo;
import org.fabric3.api.model.type.component.Binding;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.component.Reference;
import org.fabric3.api.model.type.component.Service;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.AnnotationHelper;
import org.fabric3.spi.introspection.java.InvalidAnnotation;
import org.fabric3.spi.introspection.java.PostProcessor;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public abstract class AbstractBindingPostProcessor<A extends Annotation>
implements PostProcessor {
    private Class<A> annotationType;
    private Method serviceAttribute;
    @org.oasisopen.sca.annotation.Reference
    protected HostInfo info;

    protected AbstractBindingPostProcessor(Class<A> annotationType) {
        this.annotationType = annotationType;
        try {
            this.serviceAttribute = annotationType.getDeclaredMethod("service", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)"Binding annotation must have a service attribute");
        }
    }

    @Override
    public void process(InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        this.processService(componentType, implClass, context);
        this.processReferences(componentType, implClass, context);
    }

    protected String getNullableValue(String value) {
        return value.isEmpty() ? null : value;
    }

    protected abstract Binding processService(A var1, Service<ComponentType> var2, InjectingComponentType var3, Class<?> var4, IntrospectionContext var5);

    protected abstract Binding processServiceCallback(A var1, Service<ComponentType> var2, InjectingComponentType var3, Class<?> var4, IntrospectionContext var5);

    protected abstract Binding processReference(A var1, Reference var2, Class<?> var3, IntrospectionContext var4);

    protected abstract Binding processReferenceCallback(A var1, Reference var2, Class<?> var3, IntrospectionContext var4);

    protected void processService(InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        Binding callbackBinding;
        A annotation = AnnotationHelper.findAnnotation(this.annotationType, implClass);
        if (annotation == null) {
            return;
        }
        Class<?> serviceInterface = this.getService(annotation);
        if (serviceInterface.equals(Void.class)) {
            serviceInterface = null;
        }
        Service boundService = null;
        if (serviceInterface == null) {
            if (componentType.getServices().size() != 1) {
                InvalidAnnotation error = new InvalidAnnotation("Binding annotation must specify a service interface", implClass, (Annotation)annotation, implClass);
                context.addError(error);
                return;
            }
            boundService = (Service)componentType.getServices().values().iterator().next();
        } else {
            String name = serviceInterface.getName();
            for (Service service : componentType.getServices().values()) {
                String interfaceName = service.getServiceContract().getQualifiedInterfaceName();
                if (!interfaceName.equals(name)) continue;
                boundService = service;
                break;
            }
            if (boundService == null) {
                InvalidAnnotation error = new InvalidAnnotation("Service specified in binding annotation not found: " + name, implClass, (Annotation)annotation, implClass);
                context.addError(error);
                return;
            }
        }
        Binding binding = this.processService(annotation, (Service<ComponentType>)boundService, componentType, implClass, context);
        if (binding == null) {
            return;
        }
        this.processHandlers(implClass, binding, implClass, context);
        boundService.addBinding(binding);
        ServiceContract contract = boundService.getServiceContract();
        if (contract.getCallbackContract() != null && (callbackBinding = this.processServiceCallback(annotation, (Service<ComponentType>)boundService, componentType, implClass, context)) != null) {
            boundService.addCallbackBinding(callbackBinding);
        }
    }

    protected void processReferences(InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        for (Map.Entry entry : componentType.getInjectionSiteMappings().entrySet()) {
            Annotation[] annotations;
            if (!(entry.getKey() instanceof Reference)) continue;
            Reference reference = (Reference)entry.getKey();
            InjectionSite site = (InjectionSite)entry.getValue();
            if (site instanceof FieldInjectionSite) {
                FieldInjectionSite fieldSite = (FieldInjectionSite)site;
                Field field = fieldSite.getField();
                this.processBindingAnnotations(field, reference, implClass, context);
                continue;
            }
            if (site instanceof MethodInjectionSite) {
                MethodInjectionSite methodSite = (MethodInjectionSite)site;
                Method method = methodSite.getMethod();
                this.processBindingAnnotations(method, reference, implClass, context);
                continue;
            }
            if (!(site instanceof ConstructorInjectionSite)) continue;
            ConstructorInjectionSite constructorSite = (ConstructorInjectionSite)site;
            Constructor constructor = constructorSite.getConstructor();
            for (Annotation annotation : annotations = constructor.getParameterAnnotations()[constructorSite.getParam()]) {
                Binding callbackBinding;
                Annotation castAnnotation;
                Binding binding;
                if (!this.annotationType.equals(annotation.annotationType()) || (binding = this.processReference(castAnnotation = (Annotation)this.annotationType.cast(annotation), reference, implClass, context)) == null) continue;
                reference.addBinding(binding);
                ServiceContract contract = reference.getServiceContract();
                if (contract.getCallbackContract() == null || (callbackBinding = this.processReferenceCallback(castAnnotation, reference, implClass, context)) == null) continue;
                reference.addCallbackBinding(callbackBinding);
            }
        }
    }

    protected void processBindingAnnotations(AccessibleObject object, Reference reference, Class<?> implClass, IntrospectionContext context) {
        Annotation[] annotations = object.getAnnotationsByType(this.annotationType);
        if (annotations.length == 0) {
            Annotation annotation;
            Annotation[] annotationArray = object.getAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n && (annotations = (annotation = annotationArray[i]).annotationType().getAnnotationsByType(this.annotationType)).length <= 0; ++i) {
            }
            if (annotations.length == 0) {
                return;
            }
        }
        for (Annotation annotation : annotations) {
            Binding callbackBinding;
            Binding binding = this.processReference(annotation, reference, implClass, context);
            if (binding == null) continue;
            reference.addBinding(binding);
            ServiceContract contract = reference.getServiceContract();
            if (contract.getCallbackContract() == null || (callbackBinding = this.processReferenceCallback((Annotation)this.annotationType.cast(annotation), reference, implClass, context)) == null) continue;
            reference.addCallbackBinding(callbackBinding);
        }
    }

    protected boolean isActiveForEnvironment(String[] environments) {
        if (environments.length == 0) {
            return true;
        }
        String activeEnvironment = this.info.getEnvironment();
        for (String environment : environments) {
            if (!environment.equals(activeEnvironment)) continue;
            return true;
        }
        return false;
    }

    private void processHandlers(AnnotatedElement element, Binding binding, Class<?> implClass, IntrospectionContext context) {
        BindingHandler annotation = element.getAnnotation(BindingHandler.class);
        if (annotation == null) {
            return;
        }
        if (annotation.value().isEmpty()) {
            String[] values;
            for (String value : values = annotation.handlers()) {
                this.parseHandlerUri(value, element, binding, implClass, context, annotation);
            }
        } else {
            this.parseHandlerUri(annotation.value(), element, binding, implClass, context, annotation);
        }
    }

    private void parseHandlerUri(String value, AnnotatedElement element, Binding binding, Class<?> implClass, IntrospectionContext context, BindingHandler annotation) {
        try {
            org.fabric3.api.model.type.component.BindingHandler definition = new org.fabric3.api.model.type.component.BindingHandler(new URI(value));
            binding.addHandler(definition);
        }
        catch (URISyntaxException e) {
            InvalidAnnotation error = new InvalidAnnotation("Invalid binding handler URI", element, (Annotation)annotation, implClass, e);
            context.addError(error);
        }
    }

    private Class<?> getService(A annotation) {
        try {
            return (Class)this.serviceAttribute.invoke(annotation, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
    }
}

