/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.introspection.xml;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;

public abstract class AbstractValidatingTypeLoader<OUTPUT>
implements TypeLoader<OUTPUT> {
    protected Set<String> attributes = new HashSet<String>();

    protected void addAttributes(String ... attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Attributes cannot be null");
        }
        this.attributes.addAll(Arrays.asList(attributes));
    }

    protected void validateAttributes(XMLStreamReader reader, IntrospectionContext context, ModelObject ... sources) {
        Location location = reader.getLocation();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if (this.attributes.contains(name)) continue;
            UnrecognizedAttribute failure = new UnrecognizedAttribute(name, location, sources);
            context.addError(failure);
        }
    }
}

