/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.physical;

import javax.xml.namespace.QName;
import org.w3c.dom.Document;

public class PhysicalProperty {
    private String name;
    private Document xmlValue;
    private Object instanceValue;
    private String key;
    private boolean many;
    private QName type;
    private boolean required = true;

    public String getName() {
        return this.name;
    }

    public Document getXmlValue() {
        return this.xmlValue;
    }

    public String getKey() {
        return this.key;
    }

    public Object getInstanceValue() {
        return this.instanceValue;
    }

    public boolean isMany() {
        return this.many;
    }

    public QName getType() {
        return this.type;
    }

    public boolean isRequired() {
        return this.required;
    }

    private PhysicalProperty() {
    }

    public static class Builder {
        private PhysicalProperty property = new PhysicalProperty();

        public static Builder newBuilder(String name) {
            return new Builder(name);
        }

        public Builder xmlValue(Document value) {
            this.property.xmlValue = value;
            return this;
        }

        public Builder type(QName type) {
            this.property.type = type;
            return this;
        }

        public Builder many(boolean value) {
            this.property.many = value;
            return this;
        }

        public Builder required(boolean value) {
            this.property.required = value;
            return this;
        }

        public Builder instanceValue(Object value) {
            this.property.instanceValue = value;
            return this;
        }

        public Builder key(String key) {
            this.property.key = key;
            return this;
        }

        public PhysicalProperty build() {
            return this.property;
        }

        private Builder(String name) {
            this.property.name = name;
        }
    }
}

