/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.runtime.weblogic.monitor;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.api.host.monitor.DestinationRouter;
import org.fabric3.api.host.monitor.MessageFormatter;
import weblogic.logging.LoggingHelper;
import weblogic.logging.WLLevel;

public class WebLogicDestinationRouter
implements DestinationRouter {
    private Logger logger = LoggingHelper.getServerLogger();

    public int getDestinationIndex(String name) {
        return 0;
    }

    public void send(MonitorLevel level, int destinationIndex, long timestamp, String source, String message, boolean parse, Object ... args) {
        this.write(level, message, args);
    }

    private void write(MonitorLevel level, String message, Object[] args) {
        message = MessageFormatter.format((String)message, (Object[])args);
        Level jdkLevel = this.convert(level);
        if (level == null || !this.logger.isLoggable(jdkLevel)) {
            return;
        }
        LogRecord logRecord = new LogRecord(jdkLevel, message);
        logRecord.setLoggerName("fabric3");
        logRecord.setParameters(args);
        for (Object data : args) {
            if (!(data instanceof Throwable)) continue;
            logRecord.setThrown((Throwable)data);
            break;
        }
        if (MonitorLevel.INFO == level) {
            logRecord.setLevel((Level)WLLevel.NOTICE);
        }
        this.logger.log(logRecord);
    }

    private Level convert(MonitorLevel level) {
        if (MonitorLevel.SEVERE == level) {
            return Level.SEVERE;
        }
        if (MonitorLevel.WARNING == level) {
            return Level.WARNING;
        }
        if (MonitorLevel.INFO == level) {
            return Level.INFO;
        }
        if (MonitorLevel.DEBUG == level) {
            return Level.FINE;
        }
        if (MonitorLevel.TRACE == level) {
            return Level.FINEST;
        }
        return Level.FINEST;
    }
}

