/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.runtime.weblogic.work;

import commonj.work.Work;
import commonj.work.WorkException;
import commonj.work.WorkManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.fabric3.runtime.weblogic.work.ExecutorInitException;
import org.fabric3.runtime.weblogic.work.WebLogicExecutorService;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import weblogic.logging.LoggingHelper;

@EagerInit
public class WebLogicExecutorService
implements ExecutorService {
    private WorkManager workManager;
    private Logger logger = LoggingHelper.getServerLogger();

    @Init
    public void init() throws ExecutorInitException {
        this.workManager = this.getDefaultWorkManager();
    }

    private WorkManager getDefaultWorkManager() throws ExecutorInitException {
        WorkManager wm = null;
        ClassLoader classLoader = WorkManager.class.getClassLoader();
        try {
            Class<?> clazz = Class.forName("com.bea.core.workmanager.WorkManagerFactory", true, classLoader);
            Method defaultMethod = clazz.getMethod("getDefault", new Class[0]);
            wm = (WorkManager)defaultMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.logger.log(Level.FINEST, "Did not initialize com.bea.core.workmanager.WorkManagerFactory", e);
        }
        if (wm != null) {
            return wm;
        }
        try {
            Class<?> wmWLSFactoryClass = Class.forName("weblogic.work.WorkManagerFactory", true, classLoader);
            Method instanceMethod = wmWLSFactoryClass.getMethod("getInstance", new Class[0]);
            Method defaultMethod = wmWLSFactoryClass.getMethod("getDefault", new Class[0]);
            Object wmWLSFactory = instanceMethod.invoke(null, new Object[0]);
            Object wmObj = defaultMethod.invoke(wmWLSFactory, new Object[0]);
            Class<?> wmCommonJClass = Class.forName("weblogic.work.commonj.CommonjWorkManagerImpl", true, classLoader);
            Class<?> wmWLSInterface = Class.forName("weblogic.work.WorkManager", true, classLoader);
            Constructor<?> wmCommonJConstructor = wmCommonJClass.getConstructor(wmWLSInterface);
            wm = (WorkManager)wmCommonJConstructor.newInstance(wmObj);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ExecutorInitException((Throwable)e);
        }
        return wm;
    }

    @Override
    public void execute(Runnable command) {
        try {
            if (this.workManager == null) {
                this.workManager = this.getDefaultWorkManager();
            }
            this.workManager.schedule((Work)new CommonJWorkWrapper(this, command, null));
        }
        catch (WorkException | ExecutorInitException e) {
            LogRecord record = new LogRecord(Level.SEVERE, "Error submitting work");
            record.setThrown(e);
            this.logger.log(record);
        }
    }

    @Override
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<?> submit(Runnable task) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }
}

