/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.inmem;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.NonNull;
import org.factcast.core.store.StateToken;
import org.factcast.core.store.TokenStore;

class InMemTokenStore
implements TokenStore {
    private final Map<StateToken, Map<UUID, Optional<UUID>>> tokens = Collections.synchronizedMap(new HashMap());
    private final Map<StateToken, String> namespaces = Collections.synchronizedMap(new HashMap());

    InMemTokenStore() {
    }

    @NonNull
    public StateToken create(@NonNull Map<UUID, Optional<UUID>> state, @NonNull Optional<String> ns) {
        if (state == null) {
            throw new NullPointerException("state is marked non-null but is null");
        }
        if (ns == null) {
            throw new NullPointerException("ns is marked non-null but is null");
        }
        StateToken token = new StateToken();
        this.tokens.put(token, state);
        this.namespaces.put(token, ns.orElse(null));
        return token;
    }

    public void invalidate(@NonNull StateToken token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        this.tokens.remove(token);
        this.namespaces.remove(token);
    }

    @NonNull
    public Optional<Map<UUID, Optional<UUID>>> getState(@NonNull StateToken token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        return Optional.ofNullable(this.tokens.get(token));
    }

    @NonNull
    public Optional<String> getNs(@NonNull StateToken token) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        return Optional.ofNullable(this.namespaces.get(token));
    }
}

