/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.pgsql;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.factcast.store.pgsql.CatchupStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

@ConfigurationProperties(prefix="factcast.store.pgsql")
public class PgConfigurationProperties
implements ApplicationListener<ApplicationReadyEvent> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PgConfigurationProperties.class);
    private static final String LEGACY_PREFIX = "factcast.pg";
    @Autowired
    private Environment env;
    @Autowired
    private ApplicationContext appContext;
    private int pageSize = 1000;
    private int queueSize = 1000;
    private int idOnlyFactor = 100;
    private CatchupStrategy catchupStrategy = CatchupStrategy.getDefault();
    private int queueFetchRatio = 4;

    public int getPageSizeForIds() {
        return this.pageSize * this.idOnlyFactor;
    }

    public int getQueueSizeForIds() {
        return this.queueSize * this.idOnlyFactor;
    }

    public int getFetchSizeForIds() {
        return this.getQueueSizeForIds() / this.queueFetchRatio;
    }

    public int getFetchSize() {
        return this.getQueueSize() / this.queueFetchRatio;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        List<Map.Entry> legacyProperties = this.findAllProperties().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(LEGACY_PREFIX)).collect(Collectors.toList());
        if (!legacyProperties.isEmpty()) {
            log.error("There are legacy properties detected. Property namespace has been renamed from 'factcast.pg' to 'factcast.store.pgsql'");
            legacyProperties.forEach(p -> log.error("Property {} found in {}", p.getKey(), p.getValue()));
        }
    }

    private Map<String, Object> findAllProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        MutablePropertySources propertySources = ((AbstractEnvironment)this.env).getPropertySources();
        for (PropertySource propertySource : propertySources) {
            if (!(propertySource instanceof MapPropertySource)) continue;
            Map source = (Map)((MapPropertySource)propertySource).getSource();
            source.entrySet().forEach(e -> map.put((String)e.getKey(), propertySource.toString()));
        }
        return map;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PgConfigurationProperties() {
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Environment getEnv() {
        return this.env;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ApplicationContext getAppContext() {
        return this.appContext;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getPageSize() {
        return this.pageSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getQueueSize() {
        return this.queueSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getIdOnlyFactor() {
        return this.idOnlyFactor;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CatchupStrategy getCatchupStrategy() {
        return this.catchupStrategy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getQueueFetchRatio() {
        return this.queueFetchRatio;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PgConfigurationProperties setEnv(Environment env) {
        this.env = env;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PgConfigurationProperties setAppContext(ApplicationContext appContext) {
        this.appContext = appContext;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PgConfigurationProperties setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PgConfigurationProperties setQueueSize(int queueSize) {
        this.queueSize = queueSize;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PgConfigurationProperties setIdOnlyFactor(int idOnlyFactor) {
        this.idOnlyFactor = idOnlyFactor;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PgConfigurationProperties setCatchupStrategy(CatchupStrategy catchupStrategy) {
        this.catchupStrategy = catchupStrategy;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PgConfigurationProperties setQueueFetchRatio(int queueFetchRatio) {
        this.queueFetchRatio = queueFetchRatio;
        return this;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PgConfigurationProperties)) {
            return false;
        }
        PgConfigurationProperties other = (PgConfigurationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        ApplicationContext this$appContext = this.getAppContext();
        ApplicationContext other$appContext = other.getAppContext();
        if (this$appContext == null ? other$appContext != null : !this$appContext.equals(other$appContext)) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getQueueSize() != other.getQueueSize()) {
            return false;
        }
        if (this.getIdOnlyFactor() != other.getIdOnlyFactor()) {
            return false;
        }
        CatchupStrategy this$catchupStrategy = this.getCatchupStrategy();
        CatchupStrategy other$catchupStrategy = other.getCatchupStrategy();
        if (this$catchupStrategy == null ? other$catchupStrategy != null : !((Object)((Object)this$catchupStrategy)).equals((Object)other$catchupStrategy)) {
            return false;
        }
        return this.getQueueFetchRatio() == other.getQueueFetchRatio();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PgConfigurationProperties;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        ApplicationContext $appContext = this.getAppContext();
        result = result * 59 + ($appContext == null ? 43 : $appContext.hashCode());
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getQueueSize();
        result = result * 59 + this.getIdOnlyFactor();
        CatchupStrategy $catchupStrategy = this.getCatchupStrategy();
        result = result * 59 + ($catchupStrategy == null ? 43 : ((Object)((Object)$catchupStrategy)).hashCode());
        result = result * 59 + this.getQueueFetchRatio();
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "PgConfigurationProperties(env=" + this.getEnv() + ", appContext=" + this.getAppContext() + ", pageSize=" + this.getPageSize() + ", queueSize=" + this.getQueueSize() + ", idOnlyFactor=" + this.getIdOnlyFactor() + ", catchupStrategy=" + (Object)((Object)this.getCatchupStrategy()) + ", queueFetchRatio=" + this.getQueueFetchRatio() + ")";
    }
}

