/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.pgsql.internal;

import com.google.common.eventbus.Subscribe;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import lombok.Generated;
import org.factcast.store.pgsql.internal.PgSynchronizedQuery;
import org.factcast.store.pgsql.internal.listen.PgListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CondensedQueryExecutor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CondensedQueryExecutor.class);
    private final long maxDelayInMillis;
    private final PgSynchronizedQuery target;
    private final Supplier<Boolean> connectionStateSupplier;
    private Timer timer = new Timer(CondensedQueryExecutor.class.getSimpleName() + ".timer", true);
    private final AtomicBoolean currentlyScheduled = new AtomicBoolean(false);

    public void trigger() {
        if (this.connectionStateSupplier.get().booleanValue()) {
            if (this.maxDelayInMillis < 1L) {
                this.runTarget();
            } else if (!this.currentlyScheduled.getAndSet(true)) {
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        CondensedQueryExecutor.this.currentlyScheduled.set(false);
                        try {
                            CondensedQueryExecutor.this.runTarget();
                        }
                        catch (Throwable e) {
                            log.debug("Scheduled query failed, closing: {}", (Object)e.getMessage());
                        }
                    }
                }, this.maxDelayInMillis);
            }
        }
    }

    @Subscribe
    public void onEvent(PgListener.FactInsertionEvent ev) {
        this.trigger();
    }

    protected void runTarget() {
        try {
            this.target.run(false);
        }
        catch (Throwable e) {
            log.error("cannot run Target: ", e);
        }
    }

    public void cancel() {
        this.currentlyScheduled.set(true);
        this.timer.cancel();
        this.timer.purge();
        this.currentlyScheduled.set(true);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CondensedQueryExecutor(long maxDelayInMillis, PgSynchronizedQuery target, Supplier<Boolean> connectionStateSupplier) {
        this.maxDelayInMillis = maxDelayInMillis;
        this.target = target;
        this.connectionStateSupplier = connectionStateSupplier;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    CondensedQueryExecutor(long maxDelayInMillis, PgSynchronizedQuery target, Supplier<Boolean> connectionStateSupplier, Timer timer) {
        this.maxDelayInMillis = maxDelayInMillis;
        this.target = target;
        this.connectionStateSupplier = connectionStateSupplier;
        this.timer = timer;
    }
}

