/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.pgsql.internal;

import java.util.HashMap;
import liquibase.integration.spring.SpringLiquibase;
import lombok.NonNull;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class LiquibaseChangelogParamsForwarder
implements BeanPostProcessor {
    private final DataSource dataSource;

    public LiquibaseChangelogParamsForwarder(@NonNull javax.sql.DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        this.dataSource = this.getTomcatDataSource(dataSource);
    }

    public Object postProcessBeforeInitialization(@NonNull Object bean, @NonNull String beanName) throws BeansException {
        if (bean == null) {
            throw new NullPointerException("bean is marked non-null but is null");
        }
        if (beanName == null) {
            throw new NullPointerException("beanName is marked non-null but is null");
        }
        if (bean instanceof SpringLiquibase) {
            SpringLiquibase liquibase = (SpringLiquibase)bean;
            PoolConfiguration poolProperties = this.dataSource.getPoolProperties();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("dml-user", poolProperties.getUsername());
            params.put("dml-user-pw", poolProperties.getPassword());
            liquibase.setChangeLogParameters(params);
        }
        return bean;
    }

    private DataSource getTomcatDataSource(javax.sql.DataSource dataSource) {
        if (DataSource.class.isAssignableFrom(dataSource.getClass())) {
            return (DataSource)dataSource;
        }
        throw new IllegalArgumentException("expected " + DataSource.class.getName() + " , but got " + dataSource.getClass().getName());
    }
}

