/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.pgsql.internal;

import lombok.Generated;

@Generated
public class PgConstants {
    public static final String NEXT_FROM_CATCHUP_SEQ = "SELECT nextval('catchup_seq')";
    public static final String CURRENT_TIME_MILLIS = "SELECT TRUNC(EXTRACT(EPOCH FROM now()) * 1000)";
    public static final String TABLE_CATCHUP = "catchup";
    public static final String TABLE_FACT = "fact";
    private static final String TABLE_TOKENSTORE = "tokenstore";
    public static final String CHANNEL_NAME = "fact_insert";
    public static final String COLUMN_PAYLOAD = "payload";
    public static final String COLUMN_HEADER = "header";
    public static final String COLUMN_SER = "ser";
    public static final String COLUMN_CID = "cid";
    private static final String COLUMN_STATE = "state";
    private static final String COLUMN_NAMESPACE = "ns";
    private static final String COLUMN_TOKEN = "token";
    public static final String ALIAS_ID = "id";
    public static final String ALIAS_NS = "ns";
    public static final String ALIAS_TYPE = "type";
    public static final String ALIAS_AGGID = "aggIds";
    public static final String PROJECTION_FACT = String.join((CharSequence)", ", "ser", "header", "payload", PgConstants.fromHeader("id"), PgConstants.fromHeader("aggIds"), PgConstants.fromHeader("ns"), PgConstants.fromHeader("type"));
    public static final String PROJECTION_ID = String.join((CharSequence)", ", "ser", PgConstants.empty("header"), PgConstants.empty("payload"), PgConstants.fromHeader("id"), PgConstants.fromHeader("aggIds"), PgConstants.fromHeader("ns"), PgConstants.fromHeader("type"));
    public static final String INSERT_FACT = "INSERT INTO fact(header,payload) VALUES (cast(? as jsonb),cast (? as jsonb))";
    public static final String INSERT_TOKEN = "INSERT INTO tokenstore (ns,state) VALUES (?,cast (? as jsonb)) RETURNING token";
    public static final String DELETE_TOKEN = "DELETE FROM tokenstore WHERE token=?";
    public static final String SELECT_BY_ID = "SELECT " + PROJECTION_FACT + " FROM " + "fact" + " WHERE " + "header" + " @> cast (? as jsonb)";
    public static final String SELECT_LATEST_SER = "SELECT max(ser) FROM fact";
    public static final String SELECT_ID_FROM_CATCHUP = "SELECT " + PROJECTION_ID + " FROM " + "fact" + " WHERE " + "ser" + " IN (    SELECT " + "ser" + " FROM " + "catchup" + "   WHERE ( " + "cid" + "=? AND " + "ser" + ">? ) LIMIT ? ) ORDER BY " + "ser" + " ASC";
    public static final String SELECT_FACT_FROM_CATCHUP = "SELECT " + PROJECTION_FACT + " FROM " + "fact" + " WHERE " + "ser" + " IN (    SELECT " + "ser" + " FROM " + "catchup" + "   WHERE ( " + "cid" + "=? AND " + "ser" + ">? ) LIMIT ? ) ORDER BY " + "ser" + " ASC";
    public static final String SELECT_LATEST_FACTID_FOR_AGGID = "SELECT header->>'id' FROM fact WHERE header @> cast (? as jsonb) ORDER BY ser DESC LIMIT 1";
    public static final String DELETE_CATCH_BY_CID = "DELETE FROM catchup WHERE cid=?";
    public static final String SELECT_BY_HEADER_JSON = "SELECT ser FROM fact WHERE header @> ?::jsonb";
    public static final String LISTEN_SQL = "LISTEN fact_insert";
    public static final String UPDATE_FACT_SERIALS = "update fact set header= jsonb_set( header , '{meta}' , COALESCE(header->'meta','{}') || concat('{\"_ser\":', ser ,'}' )::jsonb , true) WHERE header @> ?::jsonb";
    public static final String SELECT_DISTINCT_NAMESPACE = "SELECT DISTINCT(header->>'ns') ns FROM fact WHERE header->>'ns' IS NOT NULL";
    public static final String SELECT_DISTINCT_TYPE_IN_NAMESPACE = "SELECT DISTINCT(header->>'type')  FROM fact WHERE (header->>'ns')=? AND ( header->>'type') IS NOT NULL";
    public static final String SELECT_SER_BY_ID = "SELECT ser FROM fact WHERE header @> cast (? as jsonb)";
    public static final String SELECT_STATE_FROM_TOKEN = "SELECT state FROM tokenstore WHERE token=?";
    public static final String SELECT_NS_FROM_TOKEN = "SELECT ns FROM tokenstore WHERE token=?";

    private static String fromHeader(String attributeName) {
        return "header->>'" + attributeName + "' AS " + attributeName;
    }

    private static String empty(String attributeName) {
        return "'{}' AS " + attributeName;
    }
}

