/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.pgsql.internal;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.factcast.core.Fact;
import org.factcast.core.util.FactCastJson;

public class PgFact
implements Fact {
    @NonNull
    private final UUID id;
    @NonNull
    private final String ns;
    private final String type;
    private final Set<UUID> aggIds;
    @NonNull
    private final String jsonHeader;
    @NonNull
    private final String jsonPayload;
    @JsonProperty
    private Map<String, String> meta = null;

    public String meta(String key) {
        if (this.meta == null) {
            this.meta = this.deser();
        }
        return this.meta.get(key);
    }

    @Generated
    private Map<String, String> deser() {
        Meta deserializedMeta = (Meta)FactCastJson.readValue(Meta.class, (String)this.jsonHeader);
        return deserializedMeta.meta;
    }

    @Generated
    public static Fact from(ResultSet resultSet) {
        String id = resultSet.getString("id");
        String aggId = resultSet.getString("aggIds");
        String type = resultSet.getString("type");
        String ns = resultSet.getString("ns");
        String jsonHeader = resultSet.getString("header");
        String jsonPayload = resultSet.getString("payload");
        return new PgFact(UUID.fromString(id), ns, type, PgFact.toUUIDArray(aggId), jsonHeader, jsonPayload);
    }

    @VisibleForTesting
    static Set<UUID> toUUIDArray(String aggIdArrayAsString) {
        UUID[] readValue;
        LinkedHashSet<UUID> set = new LinkedHashSet<UUID>();
        if (aggIdArrayAsString != null && aggIdArrayAsString.trim().length() > 2 && (readValue = (UUID[])FactCastJson.readValue(UUID[].class, (String)aggIdArrayAsString)) != null) {
            set.addAll(Arrays.asList(readValue));
        }
        return set;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private PgFact(@NonNull UUID id, @NonNull String ns, String type, Set<UUID> aggIds, @NonNull String jsonHeader, @NonNull String jsonPayload) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (ns == null) {
            throw new NullPointerException("ns is marked non-null but is null");
        }
        if (jsonHeader == null) {
            throw new NullPointerException("jsonHeader is marked non-null but is null");
        }
        if (jsonPayload == null) {
            throw new NullPointerException("jsonPayload is marked non-null but is null");
        }
        this.id = id;
        this.ns = ns;
        this.type = type;
        this.aggIds = aggIds;
        this.jsonHeader = jsonHeader;
        this.jsonPayload = jsonPayload;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "PgFact(id=" + this.id() + ")";
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UUID id() {
        return this.id;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String ns() {
        return this.ns;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String type() {
        return this.type;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Set<UUID> aggIds() {
        return this.aggIds;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String jsonHeader() {
        return this.jsonHeader;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String jsonPayload() {
        return this.jsonPayload;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Meta {
        @JsonProperty
        private final Map<String, String> meta = new HashMap<String, String>();

        private Meta() {
        }
    }
}

