/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.pgsql.internal;

import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.factcast.core.Fact;
import org.factcast.core.store.AbstractFactStore;
import org.factcast.core.store.StateToken;
import org.factcast.core.store.TokenStore;
import org.factcast.core.subscription.Subscription;
import org.factcast.core.subscription.SubscriptionRequestTO;
import org.factcast.core.subscription.observer.FactObserver;
import org.factcast.store.pgsql.internal.PgConstants;
import org.factcast.store.pgsql.internal.PgFact;
import org.factcast.store.pgsql.internal.PgSubscriptionFactory;
import org.factcast.store.pgsql.internal.lock.FactTableWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class PgFactStore
extends AbstractFactStore {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PgFactStore.class);
    private static final int BATCH_SIZE = 500;
    @NonNull
    private final JdbcTemplate jdbcTemplate;
    @NonNull
    private final PgSubscriptionFactory subscriptionFactory;
    @NonNull
    private final FactTableWriteLock lock;
    @NonNull
    private final MeterRegistry registry;

    @Autowired
    public PgFactStore(JdbcTemplate jdbcTemplate, PgSubscriptionFactory subscriptionFactory, TokenStore tokenStore, FactTableWriteLock lock, MeterRegistry registry) {
        super(tokenStore);
        this.jdbcTemplate = jdbcTemplate;
        this.subscriptionFactory = subscriptionFactory;
        this.lock = lock;
        this.registry = registry;
        for (StoreMetrics.OP op : StoreMetrics.OP.values()) {
            this.timer(op, "None");
        }
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void publish(@NonNull List<? extends Fact> factsToPublish) {
        if (factsToPublish == null) {
            throw new NullPointerException("factsToPublish is marked non-null but is null");
        }
        this.time(StoreMetrics.OP.PUBLISH, () -> {
            try {
                this.lock.aquireExclusiveTXLock();
                ArrayList copiedListOfFacts = Lists.newArrayList((Iterable)factsToPublish);
                int numberOfFactsToPublish = factsToPublish.size();
                log.trace("Inserting {} fact(s) in batches of {}", (Object)numberOfFactsToPublish, (Object)500);
                this.jdbcTemplate.batchUpdate("INSERT INTO fact(header,payload) VALUES (cast(? as jsonb),cast (? as jsonb))", (Collection)copiedListOfFacts, 500, (statement, fact) -> {
                    statement.setString(1, fact.jsonHeader());
                    statement.setString(2, fact.jsonPayload());
                });
                this.jdbcTemplate.batchUpdate("update fact set header= jsonb_set( header , '{meta}' , COALESCE(header->'meta','{}') || concat('{\"_ser\":', ser ,'}' )::jsonb , true) WHERE header @> ?::jsonb", (Collection)copiedListOfFacts, 500, (statement, fact) -> {
                    String idMatch = "{\"id\":\"" + fact.id() + "\"}";
                    statement.setString(1, idMatch);
                });
            }
            catch (DuplicateKeyException dupkey) {
                throw new IllegalArgumentException(dupkey.getMessage());
            }
        });
    }

    private Fact extractFactFromResultSet(ResultSet resultSet, int rowNum) {
        return PgFact.from(resultSet);
    }

    @NonNull
    private String extractStringFromResultSet(ResultSet resultSet, int rowNum) throws SQLException {
        return resultSet.getString(1);
    }

    public Subscription subscribe(@NonNull SubscriptionRequestTO request, @NonNull FactObserver observer) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (observer == null) {
            throw new NullPointerException("observer is marked non-null but is null");
        }
        StoreMetrics.OP operation = request.continuous() ? StoreMetrics.OP.SUBSCRIBE_FOLLOW : StoreMetrics.OP.SUBSCRIBE_CATCHUP;
        return this.time(operation, () -> this.subscriptionFactory.subscribe(request, observer));
    }

    public Optional<Fact> fetchById(@NonNull UUID id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.time(StoreMetrics.OP.FETCH_BY_ID, () -> this.jdbcTemplate.query(PgConstants.SELECT_BY_ID, new Object[]{"{\"id\":\"" + id + "\"}"}, this::extractFactFromResultSet).stream().findFirst());
    }

    public OptionalLong serialOf(UUID l) {
        return this.time(StoreMetrics.OP.SERIAL_OF, () -> {
            try {
                Long res = (Long)this.jdbcTemplate.queryForObject("SELECT ser FROM fact WHERE header @> cast (? as jsonb)", new Object[]{"{\"id\":\"" + l + "\"}"}, Long.class);
                if (res != null && res > 0L) {
                    return OptionalLong.of(res);
                }
            }
            catch (EmptyResultDataAccessException emptyResultDataAccessException) {
                // empty catch block
            }
            return OptionalLong.empty();
        });
    }

    public Set<String> enumerateNamespaces() {
        return this.time(StoreMetrics.OP.ENUMERATE_NAMESPACES, () -> new HashSet(this.jdbcTemplate.query("SELECT DISTINCT(header->>'ns') ns FROM fact WHERE header->>'ns' IS NOT NULL", this::extractStringFromResultSet)));
    }

    public Set<String> enumerateTypes(String ns) {
        return this.time(StoreMetrics.OP.ENUMERATE_TYPES, () -> new HashSet(this.jdbcTemplate.query("SELECT DISTINCT(header->>'type')  FROM fact WHERE (header->>'ns')=? AND ( header->>'type') IS NOT NULL", new Object[]{ns}, this::extractStringFromResultSet)));
    }

    protected Map<UUID, Optional<UUID>> getStateFor(@NonNull Optional<String> ns, @NonNull Collection<UUID> forAggIds) {
        if (ns == null) {
            throw new NullPointerException("ns is marked non-null but is null");
        }
        if (forAggIds == null) {
            throw new NullPointerException("forAggIds is marked non-null but is null");
        }
        return this.time(StoreMetrics.OP.GET_STAGE_FOR, () -> {
            RowMapper rse = (rs, i) -> Optional.of(UUID.fromString(rs.getString(1)));
            LinkedHashMap<UUID, Object> ret = new LinkedHashMap<UUID, Object>();
            for (UUID uuid : forAggIds) {
                StringBuilder sb = new StringBuilder();
                sb.append("{");
                ns.ifPresent(s -> sb.append("\"ns\":\"").append((String)s).append("\","));
                sb.append("\"aggIds\":[\"").append(uuid).append("\"]}");
                String json = sb.toString();
                try {
                    ret.put(uuid, this.jdbcTemplate.queryForObject("SELECT header->>'id' FROM fact WHERE header @> cast (? as jsonb) ORDER BY ser DESC LIMIT 1", new Object[]{json}, rse));
                }
                catch (EmptyResultDataAccessException dont_care) {
                    ret.put(uuid, Optional.empty());
                }
            }
            return ret;
        });
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public boolean publishIfUnchanged(@NonNull List<? extends Fact> factsToPublish, @NonNull Optional<StateToken> optionalToken) {
        if (factsToPublish == null) {
            throw new NullPointerException("factsToPublish is marked non-null but is null");
        }
        if (optionalToken == null) {
            throw new NullPointerException("optionalToken is marked non-null but is null");
        }
        return this.time(StoreMetrics.OP.PUBLISH_IF_UNCHANGED, () -> {
            this.lock.aquireExclusiveTXLock();
            return super.publishIfUnchanged(factsToPublish, optionalToken);
        });
    }

    private void time(@NonNull StoreMetrics.OP operation, @NonNull Runnable r) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        if (r == null) {
            throw new NullPointerException("r is marked non-null but is null");
        }
        Timer.Sample sample = Timer.start();
        Exception exception = null;
        try {
            r.run();
        }
        catch (Exception e) {
            exception = e;
            throw e;
        }
        finally {
            this.time(operation, sample, exception);
        }
    }

    private <T> T time(@NonNull StoreMetrics.OP operation, @NonNull Supplier<T> s) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        Timer.Sample sample = Timer.start();
        Exception exception = null;
        try {
            T t = s.get();
            return t;
        }
        catch (Exception e) {
            exception = e;
            throw e;
        }
        finally {
            this.time(operation, sample, exception);
        }
    }

    private void time(@NonNull StoreMetrics.OP operation, @NonNull Timer.Sample sample, Exception e) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        if (sample == null) {
            throw new NullPointerException("sample is marked non-null but is null");
        }
        try {
            String exceptionTagValue = PgFactStore.mapException(e);
            sample.stop(this.timer(operation, exceptionTagValue));
        }
        catch (Exception exception) {
            log.warn("Failed timing operation!", (Throwable)exception);
        }
    }

    @NonNull
    private static String mapException(Exception e) {
        if (e == null) {
            return "None";
        }
        String simpleName = e.getClass().getSimpleName();
        return simpleName != null ? simpleName : e.getClass().getName();
    }

    @NonNull
    private Timer timer(@NonNull StoreMetrics.OP operation, @NonNull String exceptionTagValue) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        if (exceptionTagValue == null) {
            throw new NullPointerException("exceptionTagValue is marked non-null but is null");
        }
        Tags tags = Tags.of((Tag[])new Tag[]{Tag.of((String)"store", (String)"pgsql"), Tag.of((String)"operation", (String)operation.op()), Tag.of((String)"exception", (String)exceptionTagValue)});
        return Timer.builder((String)"factcast.store.operations").tags((Iterable)tags).register(this.registry);
    }

    public long currentTime() {
        return (Long)this.jdbcTemplate.queryForObject("SELECT TRUNC(EXTRACT(EPOCH FROM now()) * 1000)", Long.class);
    }

    static class StoreMetrics {
        static final String METRIC_NAME = "factcast.store.operations";
        static final String TAG_STORE_KEY = "store";
        static final String TAG_STORE_VALUE = "pgsql";
        static final String TAG_OPERATION_KEY = "operation";
        static final String TAG_EXCEPTION_KEY = "exception";
        static final String TAG_EXCEPTION_VALUE_NONE = "None";

        StoreMetrics() {
        }

        static enum OP {
            PUBLISH("publish"),
            SUBSCRIBE_FOLLOW("subscribe-follow"),
            SUBSCRIBE_CATCHUP("subscribe-catchup"),
            FETCH_BY_ID("fetchById"),
            SERIAL_OF("serialOf"),
            ENUMERATE_NAMESPACES("enumerateNamespaces"),
            ENUMERATE_TYPES("enumerateTypes"),
            GET_STAGE_FOR("getStateFor"),
            PUBLISH_IF_UNCHANGED("publishIfUnchanged");

            @NonNull
            private final String op;

            private OP(String op) {
                this.op = op;
            }

            @NonNull
            @SuppressFBWarnings(justification="generated code")
            @Generated
            public String op() {
                return this.op;
            }
        }
    }
}

