/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.pgsql.internal;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.sql.Connection;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import javax.sql.DataSource;
import lombok.NonNull;
import org.factcast.core.store.FactStore;
import org.factcast.store.pgsql.PgConfigurationProperties;
import org.factcast.store.pgsql.internal.LiquibaseChangelogParamsForwarder;
import org.factcast.store.pgsql.internal.PgFactStore;
import org.factcast.store.pgsql.internal.PgSubscriptionFactory;
import org.factcast.store.pgsql.internal.PgTokenStore;
import org.factcast.store.pgsql.internal.catchup.PgCatchupFactory;
import org.factcast.store.pgsql.internal.catchup.paged.PgPagedCatchUpFactory;
import org.factcast.store.pgsql.internal.listen.PgConnectionSupplier;
import org.factcast.store.pgsql.internal.listen.PgConnectionTester;
import org.factcast.store.pgsql.internal.listen.PgListener;
import org.factcast.store.pgsql.internal.lock.AdvisoryWriteLock;
import org.factcast.store.pgsql.internal.lock.FactTableWriteLock;
import org.factcast.store.pgsql.internal.query.PgFactIdToSerialMapper;
import org.factcast.store.pgsql.internal.query.PgLatestSerialFetcher;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
public class PgFactStoreInternalConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={EventBus.class})
    public EventBus eventBus() {
        return new AsyncEventBus(this.getClass().getSimpleName(), (Executor)Executors.newCachedThreadPool());
    }

    @Bean
    public PgCatchupFactory pgCatchupFactory(PgConfigurationProperties props, JdbcTemplate jdbc, PgFactIdToSerialMapper serMapper) {
        switch (props.getCatchupStrategy()) {
            case PAGED: {
                return new PgPagedCatchUpFactory(jdbc, props, serMapper);
            }
        }
        throw new IllegalArgumentException("Unmapped Strategy: " + (Object)((Object)props.getCatchupStrategy()));
    }

    @Bean
    public FactStore factStore(JdbcTemplate jdbcTemplate, PgSubscriptionFactory subscriptionFactory, PgTokenStore tokenStore, FactTableWriteLock lock, MeterRegistry registry) {
        return new PgFactStore(jdbcTemplate, subscriptionFactory, tokenStore, lock, registry);
    }

    @Bean
    public PgSubscriptionFactory pgSubscriptionFactory(JdbcTemplate jdbcTemplate, EventBus eventBus, PgFactIdToSerialMapper pgFactIdToSerialMapper, PgLatestSerialFetcher pgLatestSerialFetcher, PgCatchupFactory pgCatchupFactory) {
        return new PgSubscriptionFactory(jdbcTemplate, eventBus, pgFactIdToSerialMapper, pgLatestSerialFetcher, pgCatchupFactory);
    }

    @Bean
    public PgConnectionSupplier pgConnectionSupplier(DataSource ds) {
        return new PgConnectionSupplier(ds);
    }

    @Bean
    public LiquibaseChangelogParamsForwarder liquibaseChangelogParamsForwarder(DataSource dataSource) {
        return new LiquibaseChangelogParamsForwarder(dataSource);
    }

    @Bean
    public PgConnectionTester pgConnectionTester() {
        return new PgConnectionTester();
    }

    @Bean
    public PgListener pgListener(@NonNull PgConnectionSupplier pgConnectionSupplier, @NonNull EventBus eventBus, @NonNull Predicate<Connection> predicate) {
        if (pgConnectionSupplier == null) {
            throw new NullPointerException("pgConnectionSupplier is marked non-null but is null");
        }
        if (eventBus == null) {
            throw new NullPointerException("eventBus is marked non-null but is null");
        }
        if (predicate == null) {
            throw new NullPointerException("predicate is marked non-null but is null");
        }
        return new PgListener(pgConnectionSupplier, eventBus, predicate);
    }

    @Bean
    public PgFactIdToSerialMapper pgFactIdToSerialMapper(JdbcTemplate jdbcTemplate) {
        return new PgFactIdToSerialMapper(jdbcTemplate);
    }

    @Bean
    public PgLatestSerialFetcher pgLatestSerialFetcher(JdbcTemplate jdbcTemplate) {
        return new PgLatestSerialFetcher(jdbcTemplate);
    }

    @Bean
    public PgTokenStore pgTokenStore(JdbcTemplate jdbcTemplate) {
        return new PgTokenStore(jdbcTemplate);
    }

    @Bean
    public FactTableWriteLock factTableWriteLock(JdbcTemplate tpl) {
        return new AdvisoryWriteLock(tpl);
    }

    @Bean
    public PlatformTransactionManager txManager(DataSource ds) {
        return new DataSourceTransactionManager(ds);
    }

    @Bean
    @ConditionalOnMissingBean
    public MeterRegistry meterRegistry() {
        return new SimpleMeterRegistry();
    }
}

