/*
 * Decompiled with CFR 0.152.
 */
package org.factcast.store.pgsql.internal;

import com.google.common.eventbus.EventBus;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import lombok.NonNull;
import org.factcast.core.Fact;
import org.factcast.core.subscription.SubscriptionImpl;
import org.factcast.core.subscription.SubscriptionRequest;
import org.factcast.core.subscription.SubscriptionRequestTO;
import org.factcast.store.pgsql.internal.CondensedQueryExecutor;
import org.factcast.store.pgsql.internal.PgFact;
import org.factcast.store.pgsql.internal.PgPostQueryMatcher;
import org.factcast.store.pgsql.internal.PgSynchronizedQuery;
import org.factcast.store.pgsql.internal.catchup.PgCatchupFactory;
import org.factcast.store.pgsql.internal.query.PgFactIdToSerialMapper;
import org.factcast.store.pgsql.internal.query.PgLatestSerialFetcher;
import org.factcast.store.pgsql.internal.query.PgQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowCallbackHandler;

public class PgFactStream {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PgFactStream.class);
    private final JdbcTemplate jdbcTemplate;
    private final EventBus eventBus;
    private final PgFactIdToSerialMapper idToSerMapper;
    private final SubscriptionImpl<Fact> subscription;
    private final AtomicLong serial = new AtomicLong(0L);
    private final AtomicBoolean disconnected = new AtomicBoolean(false);
    private final PgLatestSerialFetcher fetcher;
    private final PgCatchupFactory pgCatchupFactory;
    private CondensedQueryExecutor condensedExecutor;
    private SubscriptionRequestTO request;
    private PgPostQueryMatcher postQueryMatcher;

    void connect(@NonNull SubscriptionRequestTO request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        this.request = request;
        log.debug("{} connecting subscription {}", (Object)request, (Object)request.dump());
        this.postQueryMatcher = new PgPostQueryMatcher((SubscriptionRequest)request);
        PgQueryBuilder q = new PgQueryBuilder(request);
        this.initializeSerialToStartAfter();
        String sql = q.createSQL();
        PreparedStatementSetter setter = q.createStatementSetter(this.serial);
        FactRowCallbackHandler rsHandler = new FactRowCallbackHandler(this.subscription, this.postQueryMatcher);
        PgSynchronizedQuery query = new PgSynchronizedQuery(this.jdbcTemplate, sql, setter, rsHandler, this.serial, this.fetcher);
        this.catchupAndFollow((SubscriptionRequest)request, this.subscription, query);
    }

    private void initializeSerialToStartAfter() {
        Long startingSerial = this.request.startingAfter().map(this.idToSerMapper::retrieve).orElse(0L);
        this.serial.set(startingSerial);
        log.trace("{} setting starting point to SER={}", (Object)this.request, (Object)startingSerial);
    }

    private void catchupAndFollow(SubscriptionRequest request, SubscriptionImpl<Fact> subscription, PgSynchronizedQuery query) {
        if (request.ephemeral()) {
            this.serial.set(this.fetcher.retrieveLatestSer());
        } else {
            this.catchup(this.postQueryMatcher);
        }
        if (this.isConnected()) {
            log.trace("{} signaling catchup", (Object)request);
            subscription.notifyCatchup();
        }
        if (this.isConnected() && request.continuous()) {
            long delayInMs;
            log.info("{} entering follow mode", (Object)request);
            if (request.maxBatchDelayInMs() < 1L) {
                delayInMs = 0L;
            } else {
                delayInMs = request.maxBatchDelayInMs() / 4L * 3L + (long)Math.abs(Math.random() * ((double)request.maxBatchDelayInMs() / 4.0));
                log.info("{} setting delay to {}, maxDelay was {}", new Object[]{request, delayInMs, request.maxBatchDelayInMs()});
            }
            this.condensedExecutor = new CondensedQueryExecutor(delayInMs, query, this::isConnected);
            this.eventBus.register((Object)this.condensedExecutor);
            this.condensedExecutor.trigger();
        } else {
            subscription.notifyComplete();
            log.debug("Completed {}", (Object)request);
        }
    }

    private void catchup(PgPostQueryMatcher postQueryMatcher) {
        if (this.isConnected()) {
            log.debug("{} catchup phase1 - historic facts staring with SER={}", (Object)this.request, (Object)this.serial.get());
            this.pgCatchupFactory.create(this.request, postQueryMatcher, this.subscription, this.serial).run();
        }
        if (this.isConnected()) {
            log.debug("{} catchup phase2 - facts since connect (SER={})", (Object)this.request, (Object)this.serial.get());
            this.pgCatchupFactory.create(this.request, postQueryMatcher, this.subscription, this.serial).run();
        }
    }

    private boolean isConnected() {
        return !this.disconnected.get();
    }

    public synchronized void close() {
        log.debug("{} disconnecting ", (Object)this.request);
        this.disconnected.set(true);
        if (this.condensedExecutor != null) {
            this.eventBus.unregister((Object)this.condensedExecutor);
            this.condensedExecutor.cancel();
            this.condensedExecutor = null;
        }
        log.info("{} disconnected ", (Object)this.request);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public PgFactStream(JdbcTemplate jdbcTemplate, EventBus eventBus, PgFactIdToSerialMapper idToSerMapper, SubscriptionImpl<Fact> subscription, PgLatestSerialFetcher fetcher, PgCatchupFactory pgCatchupFactory) {
        this.jdbcTemplate = jdbcTemplate;
        this.eventBus = eventBus;
        this.idToSerMapper = idToSerMapper;
        this.subscription = subscription;
        this.fetcher = fetcher;
        this.pgCatchupFactory = pgCatchupFactory;
    }

    private class FactRowCallbackHandler
    implements RowCallbackHandler {
        private final SubscriptionImpl<Fact> subscription;
        private final PgPostQueryMatcher postQueryMatcher;

        public void processRow(ResultSet rs) throws SQLException {
            if (PgFactStream.this.isConnected()) {
                if (rs.isClosed()) {
                    throw new IllegalStateException("ResultSet already closed. We should not have got here. THIS IS A BUG!");
                }
                Fact f = PgFact.from(rs);
                UUID factId = f.id();
                if (this.postQueryMatcher.test(f)) {
                    try {
                        this.subscription.notifyElement((Object)f);
                        log.trace("{} onNext called with id={}", (Object)PgFactStream.this.request, (Object)factId);
                    }
                    catch (Throwable e) {
                        log.debug("{} exception from subscription: {}", (Object)PgFactStream.this.request, (Object)e.getMessage());
                        try {
                            this.subscription.close();
                        }
                        catch (Exception e1) {
                            log.warn("{} exception while closing subscription: {}", (Object)PgFactStream.this.request, (Object)e1.getMessage());
                        }
                        rs.close();
                        throw e;
                    }
                }
                log.trace("{} filtered id={}", (Object)PgFactStream.this.request, (Object)factId);
                PgFactStream.this.serial.set(rs.getLong("ser"));
            }
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FactRowCallbackHandler(SubscriptionImpl<Fact> subscription, PgPostQueryMatcher postQueryMatcher) {
            this.subscription = subscription;
            this.postQueryMatcher = postQueryMatcher;
        }
    }
}

